/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.methods.SetMailboxesProcessor;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.jmap.draft.model.SetMailboxesRequest;
import org.apache.james.jmap.draft.model.SetMailboxesResponse;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class SetMailboxesMethod
implements Method {
    private static final Method.Request.Name METHOD_NAME = Method.Request.name("setMailboxes");
    @VisibleForTesting
    static final Method.Response.Name RESPONSE_NAME = Method.Response.name("mailboxesSet");
    private final Set<SetMailboxesProcessor> processors;
    private final MetricFactory metricFactory;

    @Inject
    public SetMailboxesMethod(Set<SetMailboxesProcessor> processors, MetricFactory metricFactory) {
        this.processors = processors;
        this.metricFactory = metricFactory;
    }

    @Override
    public Method.Request.Name requestHandled() {
        return METHOD_NAME;
    }

    @Override
    public Class<? extends JmapRequest> requestType() {
        return SetMailboxesRequest.class;
    }

    @Override
    public Stream<JmapResponse> processToStream(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)methodCallId);
        Preconditions.checkNotNull((Object)mailboxSession);
        Preconditions.checkArgument((boolean)(request instanceof SetMailboxesRequest));
        SetMailboxesRequest setMailboxesRequest = (SetMailboxesRequest)request;
        return (Stream)MDCBuilder.create().addContext("action", (Object)"SET_MAILBOXES").addContext("create", setMailboxesRequest.getCreate()).addContext("update", setMailboxesRequest.getUpdate()).addContext("destroy", setMailboxesRequest.getDestroy()).wrapArround(() -> (Stream)this.metricFactory.decorateSupplierWithTimerMetricLogP99("JMAP-" + METHOD_NAME.getName(), () -> Stream.of(JmapResponse.builder().methodCallId(methodCallId).response(this.setMailboxesResponse(setMailboxesRequest, mailboxSession)).responseName(RESPONSE_NAME).build()))).get();
    }

    private SetMailboxesResponse setMailboxesResponse(SetMailboxesRequest request, MailboxSession mailboxSession) {
        return this.processors.stream().map(processor -> processor.process(request, mailboxSession)).reduce(SetMailboxesResponse.builder(), (builder, resp) -> resp.mergeInto((SetMailboxesResponse.Builder)builder), (builder1, builder2) -> builder2.build().mergeInto((SetMailboxesResponse.Builder)builder1)).build();
    }
}

