/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.mailbox.MailboxSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public interface Method {
    public static final String JMAP_PREFIX = "JMAP-";

    public Request.Name requestHandled();

    public Class<? extends JmapRequest> requestType();

    default public Flux<JmapResponse> process(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        return Mono.fromCallable(() -> this.processToStream(request, methodCallId, mailboxSession)).flatMapMany(Flux::fromStream).subscribeOn(Schedulers.elastic());
    }

    default public Stream<JmapResponse> processToStream(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        return this.process(request, methodCallId, mailboxSession).toStream();
    }

    public static interface Response {
        public static Name name(String name) {
            return new Name(name);
        }

        public static class Name {
            private final String name;

            protected Name(String name) {
                Preconditions.checkNotNull((Object)name);
                Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
                this.name = name;
            }

            @JsonValue
            public String getName() {
                return this.name;
            }

            public boolean equals(Object obj) {
                if (obj instanceof Name) {
                    Name other = (Name)obj;
                    return Objects.equals(this.name, other.name);
                }
                return false;
            }

            public int hashCode() {
                return Objects.hash(this.name);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
            }
        }
    }

    public static interface Request {
        public static Name name(String name) {
            return new Name(name);
        }

        public static class Name {
            private final String name;

            private Name(String name) {
                Preconditions.checkNotNull((Object)name);
                Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
                this.name = name;
            }

            @JsonValue
            public String getName() {
                return this.name;
            }

            public boolean equals(Object obj) {
                if (obj instanceof Name) {
                    Name other = (Name)obj;
                    return Objects.equals(this.name, other.name);
                }
                return false;
            }

            public int hashCode() {
                return Objects.hash(this.name);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
            }
        }
    }
}

