/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.util.Collection;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.jmap.draft.model.message.view.MessageFullViewFactory;
import org.apache.james.jmap.draft.send.MailMetadata;
import org.apache.james.jmap.draft.send.MailSpool;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.server.core.Envelope;
import org.apache.james.server.core.MailImpl;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.mailet.Mail;

public class MessageSender {
    private final MailSpool mailSpool;

    @Inject
    public MessageSender(MailSpool mailSpool) {
        this.mailSpool = mailSpool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageFullViewFactory.MetaDataWithContent message, Envelope envelope, MailboxSession session) throws MessagingException {
        Mail mail = MessageSender.buildMail(message, envelope);
        try {
            this.sendMessage(message.getMessageId(), mail, session);
        }
        finally {
            LifecycleUtil.dispose((Object)mail);
        }
    }

    @VisibleForTesting
    static Mail buildMail(MessageFullViewFactory.MetaDataWithContent message, Envelope envelope) throws MessagingException {
        String name = message.getMessageId().serialize();
        MailImpl mail = MailImpl.builder().name(name).sender((MailAddress)envelope.getFrom().asOptional().orElseThrow(() -> new RuntimeException("Sender is mandatory"))).addRecipients((Collection)envelope.getRecipients()).build();
        mail.setMessageContent((MimeMessageSource)new MessageMimeMessageSource(name, message));
        return mail;
    }

    public void sendMessage(MessageId messageId, Mail mail, MailboxSession session) throws MessagingException {
        MailMetadata metadata = new MailMetadata(messageId, session.getUser().asString());
        this.mailSpool.send(mail, metadata);
    }

    public static class MessageMimeMessageSource
    extends MimeMessageSource {
        private final String id;
        private final MessageFullViewFactory.MetaDataWithContent message;

        public MessageMimeMessageSource(String id, MessageFullViewFactory.MetaDataWithContent message) {
            this.id = id;
            this.message = message;
        }

        public String getSourceId() {
            return this.id;
        }

        public InputStream getInputStream() {
            return this.message.getContent();
        }

        public long getMessageSize() {
            return this.message.getSize();
        }
    }
}

