/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.james.jmap.draft.methods.ValueWithId;
import org.apache.james.jmap.draft.model.CreationMessage;
import org.apache.james.mailbox.AttachmentContentLoader;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.field.Fields;
import org.apache.james.mime4j.field.UnstructuredFieldImpl;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.BodyPartBuilder;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.message.MultipartBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.NameValuePair;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.MimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MIMEMessageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MIMEMessageConverter.class);
    private static final String PLAIN_TEXT_MEDIA_TYPE = MediaType.PLAIN_TEXT_UTF_8.withoutParameters().toString();
    private static final String HTML_MEDIA_TYPE = MediaType.HTML_UTF_8.withoutParameters().toString();
    private static final NameValuePair UTF_8_CHARSET = new NameValuePair("charset", StandardCharsets.UTF_8.name());
    private static final String ALTERNATIVE_SUB_TYPE = "alternative";
    private static final String MIXED_SUB_TYPE = "mixed";
    private static final String RELATED_SUB_TYPE = "related";
    private static final String FIELD_PARAMETERS_SEPARATOR = ";";
    private static final String QUOTED_PRINTABLE = "quoted-printable";
    private static final String BASE64 = "base64";
    private static final String IN_REPLY_TO_HEADER = "In-Reply-To";
    private static final List<String> COMPUTED_HEADERS = ImmutableList.of((Object)"From", (Object)"Sender", (Object)"Reply-To", (Object)"To", (Object)"Cc", (Object)"Bcc", (Object)"Subject", (Object)"Message-ID", (Object)"Date", (Object)"Content-Type", (Object)"MIME-Version", (Object)"Content-Transfer-Encoding", (Object[])new String[0]);
    private static final List<String> LOWERCASED_COMPUTED_HEADERS = (List)COMPUTED_HEADERS.stream().map(s -> s.toLowerCase(Locale.ENGLISH)).collect(Guavate.toImmutableList());
    private final BasicBodyFactory bodyFactory;
    private final AttachmentContentLoader attachmentContentLoader;

    @Inject
    public MIMEMessageConverter(AttachmentContentLoader attachmentContentLoader) {
        this.attachmentContentLoader = attachmentContentLoader;
        this.bodyFactory = new BasicBodyFactory();
    }

    public byte[] convert(ValueWithId.CreationMessageEntry creationMessageEntry, ImmutableList<MessageAttachmentMetadata> messageAttachments, MailboxSession session) {
        return this.asBytes(this.convertToMime(creationMessageEntry, messageAttachments, session));
    }

    public byte[] asBytes(Message message) {
        try {
            return DefaultMessageWriter.asBytes((Message)message);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    Message convertToMime(ValueWithId.CreationMessageEntry creationMessageEntry, ImmutableList<MessageAttachmentMetadata> messageAttachments, MailboxSession session) {
        if (creationMessageEntry == null || creationMessageEntry.getValue() == null) {
            throw new IllegalArgumentException("creationMessageEntry is either null or has null message");
        }
        Message.Builder messageBuilder = Message.Builder.of();
        if (this.isMultipart((CreationMessage)creationMessageEntry.getValue(), messageAttachments)) {
            messageBuilder.setBody(this.createMultipart((CreationMessage)creationMessageEntry.getValue(), messageAttachments, session));
        } else {
            messageBuilder.setBody(this.createTextBody((CreationMessage)creationMessageEntry.getValue())).setContentTransferEncoding(QUOTED_PRINTABLE);
        }
        this.buildMimeHeaders(messageBuilder, (CreationMessage)creationMessageEntry.getValue(), messageAttachments);
        return messageBuilder.build();
    }

    private void buildMimeHeaders(Message.Builder messageBuilder, CreationMessage newMessage, ImmutableList<MessageAttachmentMetadata> messageAttachments) {
        Optional<Mailbox> fromAddress = newMessage.getFrom().filter(CreationMessage.DraftEmailer::hasValidEmail).map(this::convertEmailToMimeHeader);
        fromAddress.ifPresent(arg_0 -> ((Message.Builder)messageBuilder).setFrom(arg_0));
        fromAddress.ifPresent(arg_0 -> ((Message.Builder)messageBuilder).setSender(arg_0));
        messageBuilder.setReplyTo((Collection)newMessage.getReplyTo().stream().map(this::convertEmailToMimeHeader).collect(Collectors.toList()));
        messageBuilder.setTo((Collection)newMessage.getTo().stream().filter(CreationMessage.DraftEmailer::hasValidEmail).map(this::convertEmailToMimeHeader).collect(Collectors.toList()));
        messageBuilder.setCc((Collection)newMessage.getCc().stream().filter(CreationMessage.DraftEmailer::hasValidEmail).map(this::convertEmailToMimeHeader).collect(Collectors.toList()));
        messageBuilder.setBcc((Collection)newMessage.getBcc().stream().filter(CreationMessage.DraftEmailer::hasValidEmail).map(this::convertEmailToMimeHeader).collect(Collectors.toList()));
        messageBuilder.setSubject(newMessage.getSubject());
        messageBuilder.setMessageId(this.generateUniqueMessageId(fromAddress));
        messageBuilder.setDate(Date.from(newMessage.getDate().toInstant()), TimeZone.getTimeZone(newMessage.getDate().getZone()));
        newMessage.getInReplyToMessageId().ifPresent(id -> this.addHeader(messageBuilder, IN_REPLY_TO_HEADER, (String)id));
        if (!this.isMultipart(newMessage, messageAttachments)) {
            newMessage.getHtmlBody().ifPresent(x -> messageBuilder.setContentType(HTML_MEDIA_TYPE, new NameValuePair[]{UTF_8_CHARSET}));
        }
        newMessage.getHeaders().entrySet().stream().filter(header -> !((String)header.getKey()).trim().isEmpty()).filter(header -> !LOWERCASED_COMPUTED_HEADERS.contains(((String)header.getKey()).toLowerCase(Locale.ENGLISH))).forEach(header -> this.addMultivaluedHeader(messageBuilder, (String)header.getKey(), (String)header.getValue()));
    }

    private String generateUniqueMessageId(Optional<Mailbox> fromAddress) {
        Object noDomain = null;
        return MimeUtil.createUniqueMessageId((String)fromAddress.map(Mailbox::getDomain).orElse((String)noDomain));
    }

    private void addMultivaluedHeader(Message.Builder messageBuilder, String fieldName, String multipleValues) {
        Splitter.on((String)"\n").split((CharSequence)multipleValues).forEach(value -> this.addHeader(messageBuilder, fieldName, (String)value));
    }

    private void addHeader(Message.Builder messageBuilder, String fieldName, String value) {
        FieldParser parser = UnstructuredFieldImpl.PARSER;
        RawField rawField = new RawField(fieldName, value);
        messageBuilder.addField((Field)parser.parse((Field)rawField, DecodeMonitor.SILENT));
    }

    private boolean isMultipart(CreationMessage newMessage, ImmutableList<MessageAttachmentMetadata> messageAttachments) {
        return newMessage.getTextBody().isPresent() && newMessage.getHtmlBody().isPresent() || this.hasAttachment(messageAttachments);
    }

    private boolean hasAttachment(ImmutableList<MessageAttachmentMetadata> messageAttachments) {
        return !messageAttachments.isEmpty();
    }

    private TextBody createTextBody(CreationMessage newMessage) {
        String body = newMessage.getHtmlBody().orElse(newMessage.getTextBody().orElse(""));
        return this.bodyFactory.textBody(body, StandardCharsets.UTF_8);
    }

    private Multipart createMultipart(CreationMessage newMessage, ImmutableList<MessageAttachmentMetadata> messageAttachments, MailboxSession session) {
        try {
            if (this.hasAttachment(messageAttachments)) {
                return this.createMultipartWithAttachments(newMessage, messageAttachments, session);
            }
            return this.createMultipartAlternativeBody(newMessage);
        }
        catch (IOException e) {
            LOGGER.error("Error while creating textBody \n{}\n or htmlBody \n{}", new Object[]{newMessage.getTextBody().get(), newMessage.getHtmlBody().get(), e});
            throw new RuntimeException(e);
        }
    }

    private Multipart createMultipartWithAttachments(CreationMessage newMessage, ImmutableList<MessageAttachmentMetadata> messageAttachments, MailboxSession session) throws IOException {
        MultipartBuilder mixedMultipartBuilder = MultipartBuilder.create((String)MIXED_SUB_TYPE);
        List inlineAttachments = (List)messageAttachments.stream().filter(MessageAttachmentMetadata::isInline).collect(Guavate.toImmutableList());
        List besideAttachments = (List)messageAttachments.stream().filter(Predicate.not(MessageAttachmentMetadata::isInline)).collect(Guavate.toImmutableList());
        if (inlineAttachments.size() > 0) {
            mixedMultipartBuilder.addBodyPart((Entity)this.relatedInnerMessage(newMessage, inlineAttachments, session));
        } else {
            this.addBody(newMessage, mixedMultipartBuilder);
        }
        this.addAttachments(besideAttachments, mixedMultipartBuilder, session);
        return mixedMultipartBuilder.build();
    }

    private Message relatedInnerMessage(CreationMessage newMessage, List<MessageAttachmentMetadata> inlines, MailboxSession session) throws IOException {
        MultipartBuilder relatedMultipart = MultipartBuilder.create((String)RELATED_SUB_TYPE);
        this.addBody(newMessage, relatedMultipart);
        return Message.Builder.of().setBody(this.addAttachments(inlines, relatedMultipart, session).build()).build();
    }

    private MultipartBuilder addAttachments(List<MessageAttachmentMetadata> messageAttachments, MultipartBuilder multipartBuilder, MailboxSession session) {
        messageAttachments.forEach(this.addAttachment(multipartBuilder, session));
        return multipartBuilder;
    }

    private void addBody(CreationMessage newMessage, MultipartBuilder builder) throws IOException {
        if (newMessage.getHtmlBody().isPresent() && newMessage.getTextBody().isPresent()) {
            Multipart body = this.createMultipartAlternativeBody(newMessage);
            builder.addBodyPart(BodyPartBuilder.create().setBody(body));
        } else {
            this.addText(builder, newMessage.getTextBody());
            this.addHtml(builder, newMessage.getHtmlBody());
        }
    }

    private Multipart createMultipartAlternativeBody(CreationMessage newMessage) throws IOException {
        MultipartBuilder bodyBuilder = MultipartBuilder.create((String)ALTERNATIVE_SUB_TYPE);
        this.addText(bodyBuilder, newMessage.getTextBody());
        this.addHtml(bodyBuilder, newMessage.getHtmlBody());
        return bodyBuilder.build();
    }

    private void addText(MultipartBuilder builder, Optional<String> textBody) throws IOException {
        if (textBody.isPresent()) {
            builder.addBodyPart(BodyPartBuilder.create().use((BodyFactory)this.bodyFactory).setBody(textBody.get(), StandardCharsets.UTF_8).setContentType(PLAIN_TEXT_MEDIA_TYPE, new NameValuePair[]{UTF_8_CHARSET}).setContentTransferEncoding(QUOTED_PRINTABLE));
        }
    }

    private void addHtml(MultipartBuilder builder, Optional<String> htmlBody) throws IOException {
        if (htmlBody.isPresent()) {
            builder.addBodyPart(BodyPartBuilder.create().use((BodyFactory)this.bodyFactory).setBody(htmlBody.get(), StandardCharsets.UTF_8).setContentType(HTML_MEDIA_TYPE, new NameValuePair[]{UTF_8_CHARSET}).setContentTransferEncoding(QUOTED_PRINTABLE));
        }
    }

    private Consumer<MessageAttachmentMetadata> addAttachment(MultipartBuilder builder, MailboxSession session) {
        return att -> {
            try {
                builder.addBodyPart((Entity)this.attachmentBodyPart((MessageAttachmentMetadata)att, session));
            }
            catch (IOException | AttachmentNotFoundException e) {
                LOGGER.error("Error while creating attachment", e);
                throw new RuntimeException(e);
            }
        };
    }

    private BodyPart attachmentBodyPart(MessageAttachmentMetadata att, MailboxSession session) throws IOException, AttachmentNotFoundException {
        try (InputStream attachmentStream = this.attachmentContentLoader.load(att.getAttachment(), session);){
            BodyPartBuilder builder = BodyPartBuilder.create().use((BodyFactory)this.bodyFactory).setBody(new BasicBodyFactory().binaryBody(ByteStreams.toByteArray((InputStream)attachmentStream))).setField((Field)this.contentTypeField(att)).setField((Field)this.contentDispositionField(att.isInline())).setContentTransferEncoding(BASE64);
            this.contentId(builder, att);
            BodyPart bodyPart = builder.build();
            return bodyPart;
        }
    }

    private void contentId(BodyPartBuilder builder, MessageAttachmentMetadata att) {
        if (att.getCid().isPresent()) {
            builder.setField((Field)new RawField("Content-ID", ((Cid)att.getCid().get()).getValue()));
        }
    }

    @VisibleForTesting
    ContentTypeField contentTypeField(MessageAttachmentMetadata att) {
        ContentTypeField typeAsField = att.getAttachment().getType().asMime4J();
        if (att.getName().isPresent()) {
            return Fields.contentType((String)typeAsField.getMimeType(), (Map)ImmutableMap.builder().putAll(this.parametersWithoutName(typeAsField)).put((Object)"name", (Object)this.encode((String)att.getName().get())).build());
        }
        return typeAsField;
    }

    private ImmutableMap<String, String> parametersWithoutName(ContentTypeField typeAsField) {
        return (ImmutableMap)typeAsField.getParameters().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("name")).collect(Guavate.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private String encode(String name) {
        return EncoderUtil.encodeEncodedWord((String)name, (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN);
    }

    private ContentDispositionField contentDispositionField(boolean isInline) {
        if (isInline) {
            return Fields.contentDisposition((String)"inline");
        }
        return Fields.contentDisposition((String)"attachment");
    }

    private Mailbox convertEmailToMimeHeader(CreationMessage.DraftEmailer address) {
        if (!address.hasValidEmail()) {
            throw new IllegalArgumentException("address");
        }
        CreationMessage.EmailUserAndDomain emailUserAndDomain = address.getEmailUserAndDomain();
        return new Mailbox((String)address.getName().orElse(null), null, (String)emailUserAndDomain.getUser().orElse(null), (String)emailUserAndDomain.getDomain().orElse(null));
    }
}

