/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.github.steveash.guavate.Guavate;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.jmap.draft.json.ObjectMapperFactory;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.JmapResponseWriter;
import org.apache.james.jmap.draft.model.InvocationResponse;
import org.apache.james.jmap.draft.model.Property;
import reactor.core.publisher.Flux;

public class JmapResponseWriterImpl
implements JmapResponseWriter {
    public static final String PROPERTIES_FILTER = "propertiesFilter";
    private final ObjectMapperFactory objectMapperFactory;

    @Inject
    public JmapResponseWriterImpl(ObjectMapperFactory objectMapperFactory) {
        this.objectMapperFactory = objectMapperFactory;
    }

    @Override
    public Flux<InvocationResponse> formatMethodResponse(Flux<JmapResponse> jmapResponses) {
        return jmapResponses.map(jmapResponse -> {
            ObjectMapper objectMapper = this.newConfiguredObjectMapper((JmapResponse)jmapResponse);
            return new InvocationResponse(jmapResponse.getResponseName(), (ObjectNode)objectMapper.valueToTree((Object)jmapResponse.getResponse()), jmapResponse.getMethodCallId());
        });
    }

    private ObjectMapper newConfiguredObjectMapper(JmapResponse jmapResponse) {
        ObjectMapper objectMapper = this.objectMapperFactory.forWriting();
        SimpleFilterProvider filterProvider = jmapResponse.getFilterProvider().orElseGet(SimpleFilterProvider::new).setDefaultFilter(SimpleBeanPropertyFilter.serializeAll()).addFilter(PROPERTIES_FILTER, this.getPropertiesFilter(jmapResponse.getProperties()));
        objectMapper.setFilterProvider((FilterProvider)filterProvider);
        return objectMapper;
    }

    private PropertyFilter getPropertiesFilter(Optional<? extends Set<? extends Property>> properties) {
        return (PropertyFilter)properties.map(this::toFieldNames).map(SimpleBeanPropertyFilter::filterOutAllExcept).orElse(SimpleBeanPropertyFilter.serializeAll());
    }

    private Set<String> toFieldNames(Set<? extends Property> properties) {
        return (Set)properties.stream().map(Property::asFieldName).collect(Guavate.toImmutableSet());
    }
}

