/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.jmap.draft.exceptions.JmapFieldNotSupportedException;
import org.apache.james.jmap.draft.json.FieldNamePropertyFilter;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.GetMessagesRequest;
import org.apache.james.jmap.draft.model.GetMessagesResponse;
import org.apache.james.jmap.draft.model.MessageProperties;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.jmap.draft.model.message.view.MessageView;
import org.apache.james.jmap.draft.model.message.view.MessageViewFactory;
import org.apache.james.jmap.draft.model.message.view.MetaMessageViewFactory;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GetMessagesMethod
implements Method {
    public static final String HEADERS_FILTER = "headersFilter";
    private static final String ISSUER = "GetMessagesMethod";
    private static final Method.Request.Name METHOD_NAME = Method.Request.name("getMessages");
    private static final Method.Response.Name RESPONSE_NAME = Method.Response.name("messages");
    private final MetaMessageViewFactory messageViewFactory;
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    GetMessagesMethod(MetaMessageViewFactory messageViewFactory, MetricFactory metricFactory) {
        this.messageViewFactory = messageViewFactory;
        this.metricFactory = metricFactory;
    }

    @Override
    public Method.Request.Name requestHandled() {
        return METHOD_NAME;
    }

    @Override
    public Class<? extends JmapRequest> requestType() {
        return GetMessagesRequest.class;
    }

    @Override
    public Flux<JmapResponse> process(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)mailboxSession);
        Preconditions.checkArgument((boolean)(request instanceof GetMessagesRequest));
        GetMessagesRequest getMessagesRequest = (GetMessagesRequest)request;
        MessageProperties outputProperties = getMessagesRequest.getProperties().toOutputProperties();
        return (Flux)this.metricFactory.decorateSupplierWithTimerMetricLogP99("JMAP-" + METHOD_NAME.getName(), () -> Flux.from((Publisher)this.getMessagesResponse(mailboxSession, getMessagesRequest).map(response -> JmapResponse.builder().methodCallId(methodCallId).response((Method.Response)response).responseName(RESPONSE_NAME).properties(outputProperties.getOptionalMessageProperties()).filterProvider(this.buildOptionalHeadersFilteringFilterProvider(outputProperties)).build())).subscriberContext(ReactorUtils.context((String)"GET_MESSAGES", (MDCBuilder)this.mdc(getMessagesRequest))));
    }

    private MDCBuilder mdc(GetMessagesRequest getMessagesRequest) {
        return MDCBuilder.create().addContext("action", (Object)"GET_MESSAGES").addContext("accountId", getMessagesRequest.getAccountId()).addContext("ids", getMessagesRequest.getIds()).addContext("properties", (Object)getMessagesRequest.getProperties());
    }

    private Optional<SimpleFilterProvider> buildOptionalHeadersFilteringFilterProvider(MessageProperties properties) {
        return properties.getOptionalHeadersProperties().map(this::buildHeadersPropertyFilter).map(propertyFilter -> new SimpleFilterProvider().addFilter(HEADERS_FILTER, propertyFilter));
    }

    private PropertyFilter buildHeadersPropertyFilter(ImmutableSet<MessageProperties.HeaderProperty> headerProperties) {
        return new FieldNamePropertyFilter(fieldName -> headerProperties.contains((Object)MessageProperties.HeaderProperty.fromFieldName(fieldName)));
    }

    private Mono<GetMessagesResponse> getMessagesResponse(MailboxSession mailboxSession, GetMessagesRequest getMessagesRequest) {
        getMessagesRequest.getAccountId().ifPresent(input -> GetMessagesMethod.notImplemented("accountId"));
        MessageProperties.ReadProfile readProfile = getMessagesRequest.getProperties().computeReadLevel();
        MessageViewFactory<? extends MessageView> factory = this.messageViewFactory.getFactory(readProfile);
        Mono messageViewsMono = factory.fromMessageIds((List<MessageId>)getMessagesRequest.getIds(), mailboxSession).collectList();
        return messageViewsMono.map(messageViews -> GetMessagesResponse.builder().messages((List<? extends MessageView>)messageViews).expectedMessageIds((List<MessageId>)getMessagesRequest.getIds()).build());
    }

    private static void notImplemented(String field) {
        throw new JmapFieldNotSupportedException(ISSUER, field);
    }
}

