/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.api.projections.EmailQueryView;
import org.apache.james.jmap.draft.methods.ErrorResponse;
import org.apache.james.jmap.draft.methods.GetMessagesMethod;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.Filter;
import org.apache.james.jmap.draft.model.FilterCondition;
import org.apache.james.jmap.draft.model.GetMessageListRequest;
import org.apache.james.jmap.draft.model.GetMessageListResponse;
import org.apache.james.jmap.draft.model.GetMessagesRequest;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.jmap.draft.model.Number;
import org.apache.james.jmap.draft.utils.FilterToCriteria;
import org.apache.james.jmap.draft.utils.SortConverter;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.streams.Limit;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class GetMessageListMethod
implements Method {
    private static final long DEFAULT_POSITION = 0L;
    public static final String MAXIMUM_LIMIT = "maximumLimit";
    public static final long DEFAULT_MAXIMUM_LIMIT = 256L;
    private static final Method.Request.Name METHOD_NAME = Method.Request.name("getMessageList");
    private static final Method.Response.Name RESPONSE_NAME = Method.Response.name("messageList");
    private final MailboxManager mailboxManager;
    private final long maximumLimit;
    private final GetMessagesMethod getMessagesMethod;
    private final MailboxId.Factory mailboxIdFactory;
    private final EmailQueryView emailQueryView;
    private final JMAPConfiguration configuration;
    private final MetricFactory metricFactory;

    @Inject
    private GetMessageListMethod(MailboxManager mailboxManager, @Named(value="maximumLimit") long maximumLimit, GetMessagesMethod getMessagesMethod, MailboxId.Factory mailboxIdFactory, EmailQueryView emailQueryView, JMAPConfiguration configuration, MetricFactory metricFactory) {
        this.mailboxManager = mailboxManager;
        this.maximumLimit = maximumLimit;
        this.getMessagesMethod = getMessagesMethod;
        this.mailboxIdFactory = mailboxIdFactory;
        this.emailQueryView = emailQueryView;
        this.configuration = configuration;
        this.metricFactory = metricFactory;
    }

    @Override
    public Method.Request.Name requestHandled() {
        return METHOD_NAME;
    }

    @Override
    public Class<? extends JmapRequest> requestType() {
        return GetMessageListRequest.class;
    }

    @Override
    public Flux<JmapResponse> process(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        Preconditions.checkArgument((boolean)(request instanceof GetMessageListRequest));
        GetMessageListRequest messageListRequest = (GetMessageListRequest)request;
        return ((Flux)this.metricFactory.decorateSupplierWithTimerMetricLogP99("JMAP-" + METHOD_NAME.getName(), () -> this.process(methodCallId, mailboxSession, messageListRequest).subscriberContext(ReactorUtils.context((String)"GET_MESSAGE_LIST", (MDCBuilder)this.mdc(messageListRequest))))).subscribeOn(Schedulers.elastic());
    }

    private MDCBuilder mdc(GetMessageListRequest messageListRequest) {
        return MDCBuilder.create().addContext("action", (Object)"GET_MESSAGE_LIST").addContext("accountId", messageListRequest.getAccountId()).addContext("limit", messageListRequest.getLimit()).addContext("anchor", messageListRequest.getAnchor()).addContext("offset", messageListRequest.getAnchorOffset()).addContext("properties", messageListRequest.getFetchMessageProperties()).addContext("position", messageListRequest.getPosition()).addContext("filters", messageListRequest.getFilter()).addContext("sorts", messageListRequest.getSort()).addContext("isFetchMessage", messageListRequest.isFetchMessages()).addContext("isCollapseThread", messageListRequest.isCollapseThreads());
    }

    private Flux<JmapResponse> process(MethodCallId methodCallId, MailboxSession mailboxSession, GetMessageListRequest messageListRequest) {
        return this.getMessageListResponse(messageListRequest, mailboxSession).flatMapMany(messageListResponse -> Flux.concat((Publisher[])new Publisher[]{Mono.just((Object)JmapResponse.builder().methodCallId(methodCallId).response((Method.Response)messageListResponse).responseName(RESPONSE_NAME).build()), this.processGetMessages(messageListRequest, (GetMessageListResponse)messageListResponse, methodCallId, mailboxSession)})).onErrorResume(NotImplementedException.class, e -> Mono.just((Object)JmapResponse.builder().methodCallId(methodCallId).responseName(RESPONSE_NAME).error(ErrorResponse.builder().type("invalidArguments").description(e.getMessage()).build()).build())).onErrorResume(Filter.TooDeepFilterHierarchyException.class, e -> Mono.just((Object)JmapResponse.builder().methodCallId(methodCallId).responseName(RESPONSE_NAME).error(ErrorResponse.builder().type("invalidArguments").description(e.getMessage()).build()).build()));
    }

    private Mono<GetMessageListResponse> getMessageListResponse(GetMessageListRequest messageListRequest, MailboxSession mailboxSession) {
        long position = messageListRequest.getPosition().map(Number::asLong).orElse(0L);
        long limit = position + messageListRequest.getLimit().map(Number::asLong).orElse(this.maximumLimit);
        if (this.isListingContentInMailboxQuery(messageListRequest)) {
            Filter filter = messageListRequest.getFilter().get();
            FilterCondition condition = (FilterCondition)filter;
            String mailboxIdAsString = condition.getInMailboxes().get().iterator().next();
            MailboxId mailboxId = this.mailboxIdFactory.fromString(mailboxIdAsString);
            Limit aLimit = Limit.from((int)Math.toIntExact(limit));
            return Mono.fromCallable(() -> this.mailboxManager.getMailbox(mailboxId, mailboxSession)).subscribeOn(Schedulers.elastic()).then(this.emailQueryView.listMailboxContent(mailboxId, aLimit).skip(position).take(limit).reduce((Object)GetMessageListResponse.builder(), GetMessageListResponse.Builder::messageId).map(GetMessageListResponse.Builder::build)).onErrorResume(MailboxNotFoundException.class, e -> Mono.just((Object)GetMessageListResponse.builder().build()));
        }
        if (this.isListingContentInMailboxAfterQuery(messageListRequest)) {
            Filter filter = messageListRequest.getFilter().get();
            FilterCondition condition = (FilterCondition)filter;
            String mailboxIdAsString = condition.getInMailboxes().get().iterator().next();
            MailboxId mailboxId = this.mailboxIdFactory.fromString(mailboxIdAsString);
            ZonedDateTime after = condition.getAfter().get();
            Limit aLimit = Limit.from((int)Math.toIntExact(limit));
            return Mono.fromCallable(() -> this.mailboxManager.getMailbox(mailboxId, mailboxSession)).subscribeOn(Schedulers.elastic()).then(this.emailQueryView.listMailboxContentSinceReceivedAt(mailboxId, after, aLimit).skip(position).take(limit).reduce((Object)GetMessageListResponse.builder(), GetMessageListResponse.Builder::messageId).map(GetMessageListResponse.Builder::build)).onErrorResume(MailboxNotFoundException.class, e -> Mono.just((Object)GetMessageListResponse.builder().build()));
        }
        return this.querySearchBackend(messageListRequest, position, limit, mailboxSession);
    }

    private boolean isListingContentInMailboxQuery(GetMessageListRequest messageListRequest) {
        return this.configuration.isEmailQueryViewEnabled() && messageListRequest.getFilter().map(Filter::inMailboxFilterOnly).orElse(false) != false && messageListRequest.getSort().equals(ImmutableList.of((Object)"date desc"));
    }

    private boolean isListingContentInMailboxAfterQuery(GetMessageListRequest messageListRequest) {
        return this.configuration.isEmailQueryViewEnabled() && messageListRequest.getFilter().map(Filter::inMailboxAndAfterFiltersOnly).orElse(false) != false && messageListRequest.getSort().equals(ImmutableList.of((Object)"date desc"));
    }

    private Mono<GetMessageListResponse> querySearchBackend(GetMessageListRequest messageListRequest, long position, long limit, MailboxSession mailboxSession) {
        Mono searchQuery = Mono.fromCallable(() -> this.convertToSearchQuery(messageListRequest)).subscribeOn(Schedulers.parallel());
        return searchQuery.flatMapMany((Function)Throwing.function(query -> this.mailboxManager.search(query, mailboxSession, limit))).skip(position).reduce((Object)GetMessageListResponse.builder(), GetMessageListResponse.Builder::messageId).map(GetMessageListResponse.Builder::build);
    }

    private MultimailboxesSearchQuery convertToSearchQuery(GetMessageListRequest messageListRequest) {
        if (messageListRequest.getFilter().map(this::containsNestedMailboxFilters).orElse(false).booleanValue()) {
            throw new NotImplementedException("'inMailboxes' and 'notInMailboxes' wrapped within Filter Operators are not implemented. Review your search request.");
        }
        SearchQuery.Builder searchQueryBuilder = SearchQuery.builder();
        messageListRequest.getFilter().map(filter -> (ImmutableList)new FilterToCriteria().convert((Filter)filter).collect(Guavate.toImmutableList())).ifPresent(arg_0 -> ((SearchQuery.Builder)searchQueryBuilder).andCriteria(arg_0));
        Set<MailboxId> inMailboxes = this.buildFilterMailboxesSet(messageListRequest.getFilter(), FilterCondition::getInMailboxes);
        Set<MailboxId> notInMailboxes = this.buildFilterMailboxesSet(messageListRequest.getFilter(), FilterCondition::getNotInMailboxes);
        List<SearchQuery.Sort> sorts = SortConverter.convertToSorts(messageListRequest.getSort());
        if (!sorts.isEmpty()) {
            searchQueryBuilder.sorts(sorts);
        }
        return MultimailboxesSearchQuery.from((SearchQuery)searchQueryBuilder.build()).inMailboxes(inMailboxes).notInMailboxes(notInMailboxes).build();
    }

    private boolean containsNestedMailboxFilters(Filter filter) {
        if (filter instanceof FilterCondition) {
            return false;
        }
        return this.containsMailboxFilters(filter);
    }

    private boolean containsMailboxFilters(Filter filter) {
        return filter.breadthFirstVisit().stream().anyMatch(this::hasMailboxClause);
    }

    private boolean hasMailboxClause(FilterCondition condition) {
        return condition.getInMailboxes().isPresent() || condition.getInMailboxes().isPresent();
    }

    private Set<MailboxId> buildFilterMailboxesSet(Optional<Filter> maybeFilter, Function<FilterCondition, Optional<List<String>>> mailboxListExtractor) {
        return (Set)this.filterToFilterCondition(maybeFilter).flatMap(condition -> Guavate.stream((Optional)((Optional)mailboxListExtractor.apply((FilterCondition)condition)))).flatMap(Collection::stream).map(arg_0 -> ((MailboxId.Factory)this.mailboxIdFactory).fromString(arg_0)).collect(Guavate.toImmutableSet());
    }

    private Stream<FilterCondition> filterToFilterCondition(Optional<Filter> maybeCondition) {
        return Guavate.stream(maybeCondition).flatMap(c -> {
            if (c instanceof FilterCondition) {
                return Stream.of((FilterCondition)c);
            }
            return Stream.of(new FilterCondition[0]);
        });
    }

    private Flux<JmapResponse> processGetMessages(GetMessageListRequest messageListRequest, GetMessageListResponse messageListResponse, MethodCallId methodCallId, MailboxSession mailboxSession) {
        if (this.shouldChainToGetMessages(messageListRequest)) {
            GetMessagesRequest getMessagesRequest = GetMessagesRequest.builder().ids(messageListResponse.getMessageIds()).properties(messageListRequest.getFetchMessageProperties()).build();
            return this.getMessagesMethod.process(getMessagesRequest, methodCallId, mailboxSession);
        }
        return Flux.empty();
    }

    private boolean shouldChainToGetMessages(GetMessageListRequest messageListRequest) {
        return messageListRequest.isFetchMessages().orElse(false) != false && messageListRequest.isFetchThreads().orElse(false) == false;
    }
}

