/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;

public class JMAPDraftConfiguration {
    private final boolean enabled;
    private final String keystore;
    private final String secret;
    private final Optional<String> jwtPublicKeyPem;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    JMAPDraftConfiguration(boolean enabled, String keystore, String secret, Optional<String> jwtPublicKeyPem) {
        this.enabled = enabled;
        this.keystore = keystore;
        this.secret = secret;
        this.jwtPublicKeyPem = jwtPublicKeyPem;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public String getSecret() {
        return this.secret;
    }

    public Optional<String> getJwtPublicKeyPem() {
        return this.jwtPublicKeyPem;
    }

    public static class Builder {
        private String keystore;
        private String secret;
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<String> jwtPublicKeyPem = Optional.empty();

        private Builder() {
        }

        public Builder keystore(String keystore) {
            this.keystore = keystore;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(enabled);
            return this;
        }

        public Builder enable() {
            return this.enabled(true);
        }

        public Builder disable() {
            return this.enabled(false);
        }

        public Builder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public Builder jwtPublicKeyPem(Optional<String> jwtPublicKeyPem) {
            Preconditions.checkNotNull(jwtPublicKeyPem);
            this.jwtPublicKeyPem = jwtPublicKeyPem;
            return this;
        }

        public JMAPDraftConfiguration build() {
            Preconditions.checkState((boolean)this.enabled.isPresent(), (Object)"You should specify if JMAP server should be started");
            Preconditions.checkState((this.enabled.get() == false || !Strings.isNullOrEmpty((String)this.keystore) ? 1 : 0) != 0, (Object)"'keystore' is mandatory");
            Preconditions.checkState((this.enabled.get() == false || !Strings.isNullOrEmpty((String)this.secret) ? 1 : 0) != 0, (Object)"'secret' is mandatory");
            Preconditions.checkState((this.enabled.get() == false || this.jwtPublicKeyPem.isPresent() ? 1 : 0) != 0, (Object)"'publicKey' is mandatory");
            return new JMAPDraftConfiguration(this.enabled.get(), this.keystore, this.secret, this.jwtPublicKeyPem);
        }
    }
}

