/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.mdc;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.webadmin.mdc.RequestId;
import org.apache.james.webadmin.mdc.RequestLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Filter;
import spark.Request;
import spark.Response;

public class LoggingRequestFilter
implements Filter {
    public static final Logger LOGGER = LoggerFactory.getLogger(LoggingRequestFilter.class);
    public static final String REQUEST_BODY = "request-body";
    public static final String METHOD = "method";
    public static final String ENDPOINT = "endpoint";
    public static final String QUERY_PARAMETERS = "queryParameters";
    public static final String IP = "ip";
    public static final String REQUEST_ID = "requestId";
    private final Set<RequestLogger> requestLoggers;

    public static LoggingRequestFilter create() {
        return new LoggingRequestFilter((Set<RequestLogger>)ImmutableSet.of());
    }

    @Inject
    public LoggingRequestFilter(Set<RequestLogger> requestLoggers) {
        this.requestLoggers = requestLoggers;
    }

    public void handle(Request request, Response response) {
        RequestId requestId = RequestId.random();
        request.attribute(REQUEST_ID, (Object)requestId);
        this.requestLoggers.stream().filter(requestLogger -> requestLogger.applies(request)).findFirst().orElse(DefaultRequestLogger.INSTANCE).log(request, requestId);
    }

    private static class DefaultRequestLogger
    implements RequestLogger {
        private static final DefaultRequestLogger INSTANCE = new DefaultRequestLogger();

        private DefaultRequestLogger() {
        }

        @Override
        public boolean applies(Request request) {
            return true;
        }

        @Override
        public void log(Request request, RequestId requestId) {
            MDCStructuredLogger.forLogger((Logger)LOGGER).addField(LoggingRequestFilter.REQUEST_ID, (Object)requestId.asString()).addField(LoggingRequestFilter.IP, (Object)request.ip()).addField(LoggingRequestFilter.ENDPOINT, (Object)request.url()).addField(LoggingRequestFilter.METHOD, (Object)request.requestMethod()).addField("LOGIN", request.attribute("LOGIN")).addField(LoggingRequestFilter.QUERY_PARAMETERS, (Object)ImmutableSet.copyOf((Collection)request.queryParams())).addField(LoggingRequestFilter.REQUEST_BODY, (Object)request.body()).log(logger -> logger.info("WebAdmin request received"));
        }
    }
}

