/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.vacation;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.core.MailAddress;

public class RecipientId {
    private final MailAddress mailAddress;

    public static RecipientId fromMailAddress(MailAddress mailAddress) {
        Preconditions.checkNotNull((Object)mailAddress, (Object)"RecipientId mailAddress should not be null");
        return new RecipientId(mailAddress);
    }

    private RecipientId(MailAddress mailAddress) {
        this.mailAddress = mailAddress;
    }

    public MailAddress getMailAddress() {
        return this.mailAddress;
    }

    public String getAsString() {
        return this.mailAddress.toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipientId accountId = (RecipientId)o;
        return Objects.equals(this.mailAddress, accountId.mailAddress);
    }

    public int hashCode() {
        return Objects.hash(this.mailAddress);
    }
}

