/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.util.html.HtmlTextExtractor;
import org.apache.james.util.mime.MessageContentExtractor;

public class Preview {
    public static final Preview EMPTY = Preview.from("");
    private static final int MAX_LENGTH = 256;
    private final String value;

    public static Preview from(String value) {
        return new Preview(value);
    }

    public static Preview compute(String textBody) {
        return Preview.from(Preview.truncateToMaxLength(StringUtils.normalizeSpace((String)textBody)));
    }

    private static String truncateToMaxLength(String body) {
        return StringUtils.left((String)body, (int)256);
    }

    @VisibleForTesting
    Preview(String value) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((value.length() <= 256 ? 1 : 0) != 0, (Object)String.format("the preview value '%s' has length longer than %d", value, 256));
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof Preview) {
            Preview preview = (Preview)o;
            return Objects.equals(this.value, preview.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }

    public static class Factory {
        private final MessageContentExtractor messageContentExtractor;
        private final HtmlTextExtractor htmlTextExtractor;

        @Inject
        public Factory(MessageContentExtractor messageContentExtractor, HtmlTextExtractor htmlTextExtractor) {
            this.messageContentExtractor = messageContentExtractor;
            this.htmlTextExtractor = htmlTextExtractor;
        }

        public Preview fromMessageResult(MessageResult messageResult) throws MailboxException, IOException {
            try (InputStream inputStream = messageResult.getFullContent().getInputStream();){
                Preview preview = this.fromInputStream(inputStream);
                return preview;
            }
        }

        public Preview fromMessageAsString(String messageAsString) throws IOException {
            return this.fromInputStream(new ByteArrayInputStream(messageAsString.getBytes(StandardCharsets.UTF_8)));
        }

        private Preview fromInputStream(InputStream inputStream) throws IOException {
            return this.fromMime4JMessage(this.parse(inputStream));
        }

        private Preview fromMime4JMessage(Message mimeMessage) throws IOException {
            MessageContentExtractor.MessageContent messageContent = this.messageContentExtractor.extract(mimeMessage);
            return messageContent.extractMainTextContent(this.htmlTextExtractor).map(Preview::compute).orElse(EMPTY);
        }

        private Message parse(InputStream inputStream) throws IOException {
            return Message.Builder.of().use(MimeConfig.PERMISSIVE).parse(inputStream).build();
        }
    }
}

