/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.util;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.ParseException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.redirect.AddressExtractor;
import org.apache.james.transport.mailets.redirect.RedirectNotify;
import org.apache.james.transport.mailets.redirect.SpecialAddress;
import org.apache.james.transport.mailets.redirect.SpecialAddressKind;
import org.apache.james.transport.util.MailAddressUtils;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecialAddressesUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpecialAddressesUtils.class);
    private final RedirectNotify mailet;

    public static SpecialAddressesUtils from(RedirectNotify mailet) {
        return new SpecialAddressesUtils(mailet);
    }

    public SpecialAddressesUtils(RedirectNotify genericMailet) {
        this.mailet = genericMailet;
    }

    public List<MailAddress> replaceSpecialAddresses(Mail mailWithReplacementAddresses, List<MailAddress> mailAddresses) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MailAddress mailAddress : mailAddresses) {
            builder.addAll(this.getCorrespondingAddress(mailWithReplacementAddresses, mailAddress));
        }
        return builder.build();
    }

    private Collection<MailAddress> getCorrespondingAddress(Mail mail, MailAddress mailAddress) {
        if (!SpecialAddress.isSpecialAddress(mailAddress)) {
            return ImmutableSet.of((Object)mailAddress);
        }
        SpecialAddressKind specialAddressKind = SpecialAddressKind.forValue(mailAddress.getLocalPart());
        if (specialAddressKind == null) {
            return ImmutableSet.of((Object)mailAddress);
        }
        switch (specialAddressKind) {
            case SENDER: 
            case FROM: 
            case REVERSE_PATH: {
                return (Collection)mail.getMaybeSender().asOptional().map(ImmutableSet::of).orElse(ImmutableSet.of());
            }
            case REPLY_TO: {
                return this.getReplyTosFromMail(mail);
            }
            case RECIPIENTS: 
            case TO: {
                return mail.getRecipients();
            }
            case UNALTERED: 
            case NULL: {
                break;
            }
            case DELETE: {
                return ImmutableSet.of((Object)mailAddress);
            }
        }
        return ImmutableList.of();
    }

    private Set<MailAddress> getReplyTosFromMail(Mail mail) {
        try {
            InternetAddress[] replyToArray = (InternetAddress[])mail.getMessage().getReplyTo();
            if (replyToArray == null || replyToArray.length == 0) {
                return this.getSender(mail);
            }
            return this.getReplyTos(replyToArray);
        }
        catch (MessagingException ae) {
            LOGGER.warn("Unable to parse the \"REPLY_TO\" header in the original message; ignoring.");
            return ImmutableSet.of();
        }
    }

    private Set<MailAddress> getSender(Mail mail) {
        return (Set)mail.getMaybeSender().asStream().collect(Guavate.toImmutableSet());
    }

    private Set<MailAddress> getReplyTos(InternetAddress[] replyToArray) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (InternetAddress replyTo : replyToArray) {
            try {
                builder.add((Object)new MailAddress(replyTo));
            }
            catch (ParseException pe) {
                LOGGER.warn("Unable to parse a \"REPLY_TO\" header address in the original message: {}; ignoring.", (Object)replyTo);
            }
        }
        return builder.build();
    }

    public List<MailAddress> replaceInternetAddresses(Mail mailWithReplacementAddresses, List<InternetAddress> internetAddresses) throws MessagingException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (InternetAddress internetAddress : internetAddresses) {
            builder.addAll(this.getCorrespondingAddress(internetAddress, mailWithReplacementAddresses));
        }
        return builder.build();
    }

    private Collection<MailAddress> getCorrespondingAddress(InternetAddress internetAddress, Mail mail) throws AddressException {
        MailAddress mailAddress = new MailAddress(internetAddress);
        if (!SpecialAddress.isSpecialAddress(mailAddress)) {
            return ImmutableSet.of((Object)new MailAddress(internetAddress));
        }
        SpecialAddressKind specialAddressKind = SpecialAddressKind.forValue(mailAddress.getLocalPart());
        if (specialAddressKind == null) {
            return ImmutableSet.of((Object)new MailAddress(internetAddress));
        }
        switch (specialAddressKind) {
            case SENDER: 
            case REVERSE_PATH: {
                return this.getSender(mail);
            }
            case FROM: {
                try {
                    InternetAddress[] fromArray = (InternetAddress[])mail.getMessage().getFrom();
                    return this.allOrSender(mail, fromArray);
                }
                catch (MessagingException me) {
                    LOGGER.warn("Unable to parse the \"FROM\" header in the original message; ignoring.");
                    return ImmutableSet.of();
                }
            }
            case REPLY_TO: {
                try {
                    InternetAddress[] replyToArray = (InternetAddress[])mail.getMessage().getReplyTo();
                    return this.allOrSender(mail, replyToArray);
                }
                catch (MessagingException me) {
                    LOGGER.warn("Unable to parse the \"REPLY_TO\" header in the original message; ignoring.");
                    return ImmutableSet.of();
                }
            }
            case RECIPIENTS: 
            case TO: {
                return this.toHeaders(mail);
            }
            case UNALTERED: 
            case NULL: {
                return ImmutableList.of();
            }
            case DELETE: {
                return ImmutableSet.of((Object)new MailAddress(internetAddress));
            }
        }
        return ImmutableList.of();
    }

    private List<MailAddress> allOrSender(Mail mail, InternetAddress[] addresses) throws AddressException {
        if (addresses != null) {
            return MailAddressUtils.from(addresses);
        }
        return mail.getMaybeSender().asList();
    }

    private List<MailAddress> toHeaders(Mail mail) {
        try {
            String[] toHeaders = mail.getMessage().getHeader("To");
            if (toHeaders != null) {
                for (String toHeader : toHeaders) {
                    try {
                        InternetAddress[] originalToInternetAddresses = InternetAddress.parse((String)toHeader, (boolean)false);
                        return MailAddressUtils.from(originalToInternetAddresses);
                    }
                    catch (MessagingException ae) {
                        LOGGER.warn("Unable to parse a \"TO\" header address in the original message: {}; ignoring.", (Object)toHeader);
                    }
                }
            }
            return ImmutableList.of();
        }
        catch (MessagingException ae) {
            LOGGER.warn("Unable to parse the \"TO\" header  in the original message; ignoring.");
            return ImmutableList.of();
        }
    }

    public Optional<MailAddress> getFirstSpecialAddressIfMatchingOrGivenAddress(Optional<String> givenAddress, List<String> allowedSpecials) throws MessagingException {
        List<MailAddress> extractAddresses = AddressExtractor.withContext(this.mailet.getMailetContext()).allowedSpecials(allowedSpecials).extract(givenAddress);
        return extractAddresses.stream().findFirst();
    }
}

