/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.api.MailPrioritySupport;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.apache.mailet.base.MailetUtil;

public abstract class AbstractPriorityMatcher
extends GenericMatcher {
    private final String priorityMatcherName;
    private Integer priority;

    public AbstractPriorityMatcher(String priorityMatcherName) {
        this.priorityMatcherName = priorityMatcherName;
    }

    public void init() throws MessagingException {
        Integer priority = MailetUtil.getInitParameterAsStrictlyPositiveInteger((String)this.getCondition());
        this.setPriority(priority);
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        return AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)MailPrioritySupport.MAIL_PRIORITY, Integer.class).filter(this::priorityMatch).map(any -> mail.getRecipients()).orElse((Collection)ImmutableList.of());
    }

    public abstract boolean priorityMatch(Integer var1);

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getPriorityMatcherName() {
        return this.priorityMatcherName;
    }
}

