/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.ObjectNotFoundException;
import org.apache.james.blob.api.ObjectStoreIOException;
import org.apache.james.blob.cassandra.CassandraBucketDAO;
import org.apache.james.blob.cassandra.CassandraDefaultBucketDAO;
import org.apache.james.util.DataChunker;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraBlobStoreDAO
implements BlobStoreDAO {
    public static final boolean LAZY = false;
    private final CassandraDefaultBucketDAO defaultBucketDAO;
    private final CassandraBucketDAO bucketDAO;
    private final CassandraConfiguration configuration;
    private final BucketName defaultBucket;

    @Inject
    @VisibleForTesting
    public CassandraBlobStoreDAO(CassandraDefaultBucketDAO defaultBucketDAO, CassandraBucketDAO bucketDAO, CassandraConfiguration cassandraConfiguration, @Named(value="defaultBucket") BucketName defaultBucket) {
        this.defaultBucketDAO = defaultBucketDAO;
        this.bucketDAO = bucketDAO;
        this.configuration = cassandraConfiguration;
        this.defaultBucket = defaultBucket;
    }

    public InputStream read(BucketName bucketName, BlobId blobId) throws ObjectStoreIOException, ObjectNotFoundException {
        return ReactorUtils.toInputStream(this.readBlobParts(bucketName, blobId));
    }

    public Mono<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        return this.readBlobParts(bucketName, blobId).collectList().map(this::byteBuffersToBytesArray);
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, byte[] data) {
        Preconditions.checkNotNull((Object)data);
        return Mono.fromCallable(() -> DataChunker.chunk((byte[])data, (int)this.configuration.getBlobPartSize())).flatMap(chunks -> this.save(bucketName, blobId, (Flux<ByteBuffer>)chunks));
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, InputStream inputStream) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)inputStream);
        return Mono.fromCallable(() -> DataChunker.chunkStream((InputStream)inputStream, (int)this.configuration.getBlobPartSize())).flatMap(chunks -> this.save(bucketName, blobId, (Flux<ByteBuffer>)chunks)).onErrorMap(e -> new ObjectStoreIOException("Exception occurred while saving input stream", e));
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, ByteSource content) {
        return Mono.using(() -> ((ByteSource)content).openBufferedStream(), stream -> this.save(bucketName, blobId, (InputStream)stream), (Consumer)Throwing.consumer(InputStream::close).sneakyThrow(), (boolean)false);
    }

    private Mono<Void> save(BucketName bucketName, BlobId blobId, Flux<ByteBuffer> chunksAsFlux) {
        return this.saveBlobParts(bucketName, blobId, chunksAsFlux).flatMap(numberOfChunk -> this.saveBlobPartReference(bucketName, blobId, (Integer)numberOfChunk));
    }

    private Mono<Integer> saveBlobParts(BucketName bucketName, BlobId blobId, Flux<ByteBuffer> chunksAsFlux) {
        return chunksAsFlux.index().concatMap(pair -> this.writePart(bucketName, blobId, ((Long)pair.getT1()).intValue(), (ByteBuffer)pair.getT2())).count().map(Long::intValue);
    }

    private Mono<?> writePart(BucketName bucketName, BlobId blobId, int position, ByteBuffer data) {
        Mono<Void> write = this.isDefaultBucket(bucketName) ? this.defaultBucketDAO.writePart(data, blobId, position) : this.bucketDAO.writePart(data, bucketName, blobId, position);
        int anyNonEmptyValue = 1;
        return write.thenReturn((Object)anyNonEmptyValue);
    }

    private Mono<Void> saveBlobPartReference(BucketName bucketName, BlobId blobId, Integer numberOfChunk) {
        if (this.isDefaultBucket(bucketName)) {
            return this.defaultBucketDAO.saveBlobPartsReferences(blobId, numberOfChunk);
        }
        return this.bucketDAO.saveBlobPartsReferences(bucketName, blobId, numberOfChunk);
    }

    private boolean isDefaultBucket(BucketName bucketName) {
        return bucketName.equals((Object)this.defaultBucket);
    }

    public Mono<Void> delete(BucketName bucketName, BlobId blobId) {
        if (this.isDefaultBucket(bucketName)) {
            return this.defaultBucketDAO.deletePosition(blobId).then(this.defaultBucketDAO.deleteParts(blobId));
        }
        return this.bucketDAO.deletePosition(bucketName, blobId).then(this.bucketDAO.deleteParts(bucketName, blobId));
    }

    public Mono<Void> deleteBucket(BucketName bucketName) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkArgument((!this.isDefaultBucket(bucketName) ? 1 : 0) != 0, (Object)"Deleting the default bucket is forbidden");
        return this.bucketDAO.listAll().filter(bucketNameBlobIdPair -> ((BucketName)bucketNameBlobIdPair.getKey()).equals((Object)bucketName)).map(Pair::getValue).flatMap(blobId -> this.delete(bucketName, (BlobId)blobId), 16).then();
    }

    private Mono<ByteBuffer> readPart(BucketName bucketName, BlobId blobId, Integer partIndex) {
        if (this.isDefaultBucket(bucketName)) {
            return this.defaultBucketDAO.readPart(blobId, partIndex);
        }
        return this.bucketDAO.readPart(bucketName, blobId, partIndex);
    }

    private Mono<Integer> selectRowCount(BucketName bucketName, BlobId blobId) {
        if (this.isDefaultBucket(bucketName)) {
            return this.defaultBucketDAO.selectRowCount(blobId);
        }
        return this.bucketDAO.selectRowCount(bucketName, blobId);
    }

    private Flux<ByteBuffer> readBlobParts(BucketName bucketName, BlobId blobId) {
        return this.selectRowCount(bucketName, blobId).single().onErrorMap(NoSuchElementException.class, e -> new ObjectNotFoundException(String.format("Could not retrieve blob metadata for %s", blobId))).flatMapMany(rowCount -> Flux.range((int)0, (int)rowCount).concatMap(partIndex -> this.readPart(bucketName, blobId, (Integer)partIndex).single().onErrorMap(NoSuchElementException.class, e -> new ObjectNotFoundException(String.format("Missing blob part for blobId %s and position %d", blobId.asString(), partIndex)))));
    }

    private byte[] byteBuffersToBytesArray(List<ByteBuffer> byteBuffers) {
        int targetSize = byteBuffers.stream().mapToInt(Buffer::remaining).sum();
        return byteBuffers.stream().reduce(ByteBuffer.allocate(targetSize), ByteBuffer::put).array();
    }
}

