/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.vault.routes;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.vault.search.Query;
import org.apache.james.webadmin.vault.routes.ExportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedMessagesVaultExportTask
implements Task {
    static final TaskType TYPE = TaskType.of((String)"deleted-messages-export");
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletedMessagesVaultExportTask.class);
    private final ExportService exportService;
    private final Username userExportFrom;
    @VisibleForTesting
    final Query exportQuery;
    private final MailAddress exportTo;
    private final AtomicLong totalExportedMessages;

    DeletedMessagesVaultExportTask(ExportService exportService, Username userExportFrom, Query exportQuery, MailAddress exportTo) {
        this.exportService = exportService;
        this.userExportFrom = userExportFrom;
        this.exportQuery = exportQuery;
        this.exportTo = exportTo;
        this.totalExportedMessages = new AtomicLong();
    }

    public Task.Result run() {
        try {
            Runnable messageToShareCallback = this.totalExportedMessages::incrementAndGet;
            this.exportService.export(this.userExportFrom, this.exportQuery, this.exportTo, messageToShareCallback);
            return Task.Result.COMPLETED;
        }
        catch (IOException e) {
            LOGGER.error("Error happens when exporting deleted messages from {} to {}", (Object)this.userExportFrom.asString(), (Object)this.exportTo.asString());
            return Task.Result.PARTIAL;
        }
    }

    public TaskType type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.userExportFrom, this.exportTo, this.totalExportedMessages.get(), Clock.systemUTC().instant()));
    }

    Username getUserExportFrom() {
        return this.userExportFrom;
    }

    MailAddress getExportTo() {
        return this.exportTo;
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Username userExportFrom;
        private final MailAddress exportTo;
        private final long totalExportedMessages;
        private final Instant timestamp;

        public AdditionalInformation(Username userExportFrom, MailAddress exportTo, long totalExportedMessages, Instant timestamp) {
            this.userExportFrom = userExportFrom;
            this.exportTo = exportTo;
            this.totalExportedMessages = totalExportedMessages;
            this.timestamp = timestamp;
        }

        public String getUserExportFrom() {
            return this.userExportFrom.asString();
        }

        public String getExportTo() {
            return this.exportTo.asString();
        }

        public long getTotalExportedMessages() {
            return this.totalExportedMessages;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

