/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Named;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.james.events.EventListener;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.JMAPServer;
import org.apache.james.jmap.Version;
import org.apache.james.jmap.change.MailboxChangeListener;
import org.apache.james.jmap.core.Capability;
import org.apache.james.jmap.core.DefaultCapabilities;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.MaxSizeUpload;
import org.apache.james.jmap.draft.DraftMethodsModule;
import org.apache.james.jmap.draft.JMAPCommonModule;
import org.apache.james.jmap.draft.JMAPDraftConfiguration;
import org.apache.james.jmap.draft.methods.RequestHandler;
import org.apache.james.jmap.draft.send.PostDequeueDecoratorFactory;
import org.apache.james.jmap.draft.utils.JsoupHtmlTextExtractor;
import org.apache.james.jmap.event.PropagateLookupRightListener;
import org.apache.james.jmap.mailet.VacationMailet;
import org.apache.james.jmap.mailet.filter.JMAPFiltering;
import org.apache.james.jmap.rfc8621.RFC8621MethodsModule;
import org.apache.james.jwt.JwtConfiguration;
import org.apache.james.jwt.JwtTokenVerifier;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.modules.server.CamelMailetContainerModule;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.server.core.configuration.FileConfigurationProvider;
import org.apache.james.transport.matchers.All;
import org.apache.james.transport.matchers.RecipientIsLocal;
import org.apache.james.util.Port;
import org.apache.james.util.html.HtmlTextExtractor;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMAPModule
extends AbstractModule {
    private static final int DEFAULT_JMAP_PORT = 80;
    private static final Logger LOGGER = LoggerFactory.getLogger(JMAPModule.class);
    public static final CamelMailetContainerModule.DefaultProcessorsConfigurationSupplier DEFAULT_JMAP_PROCESSORS_CONFIGURATION_SUPPLIER = () -> {
        try {
            return FileConfigurationProvider.getConfig((InputStream)ClassLoader.getSystemResourceAsStream("defaultJmapMailetContainer.xml"));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    };
    public static final CamelMailetContainerModule.ProcessorsCheck VACATION_MAILET_CHECK = CamelMailetContainerModule.ProcessorsCheck.Or.of((CamelMailetContainerModule.ProcessorsCheck[])new CamelMailetContainerModule.ProcessorsCheck[]{new CamelMailetContainerModule.ProcessorsCheck.Impl("transport", RecipientIsLocal.class, VacationMailet.class), new CamelMailetContainerModule.ProcessorsCheck.Impl("local-delivery", All.class, VacationMailet.class)});
    public static final CamelMailetContainerModule.ProcessorsCheck FILTERING_MAILET_CHECK = CamelMailetContainerModule.ProcessorsCheck.Or.of((CamelMailetContainerModule.ProcessorsCheck[])new CamelMailetContainerModule.ProcessorsCheck[]{new CamelMailetContainerModule.ProcessorsCheck.Impl("transport", RecipientIsLocal.class, JMAPFiltering.class), new CamelMailetContainerModule.ProcessorsCheck.Impl("local-delivery", All.class, JMAPFiltering.class)});

    protected void configure() {
        this.install((Module)new JMAPCommonModule());
        this.install((Module)new DraftMethodsModule());
        this.install((Module)new RFC8621MethodsModule());
        this.install(binder -> binder.bind(CamelMailetContainerModule.DefaultProcessorsConfigurationSupplier.class).toInstance((Object)DEFAULT_JMAP_PROCESSORS_CONFIGURATION_SUPPLIER));
        this.bind(JMAPServer.class).in(Scopes.SINGLETON);
        this.bind(RequestHandler.class).in(Scopes.SINGLETON);
        this.bind(JsoupHtmlTextExtractor.class).in(Scopes.SINGLETON);
        this.bind(HtmlTextExtractor.class).to(JsoupHtmlTextExtractor.class);
        Multibinder.newSetBinder((Binder)this.binder(), StartUpCheck.class).addBinding().to(RequiredCapabilitiesStartUpCheck.class);
        this.bind(MailQueueItemDecoratorFactory.class).to(PostDequeueDecoratorFactory.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.GroupEventListener.class).addBinding().to(PropagateLookupRightListener.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.GroupEventListener.class).addBinding().to(MailboxChangeListener.class);
        Multibinder supportedVersions = Multibinder.newSetBinder((Binder)this.binder(), Version.class);
        supportedVersions.addBinding().toInstance((Object)Version.DRAFT);
        supportedVersions.addBinding().toInstance((Object)Version.RFC8621);
        Multibinder supportedCapabilities = Multibinder.newSetBinder((Binder)this.binder(), Capability.class);
        supportedCapabilities.addBinding().toInstance((Object)DefaultCapabilities.MAIL_CAPABILITY());
        supportedCapabilities.addBinding().toInstance((Object)DefaultCapabilities.QUOTA_CAPABILITY());
        supportedCapabilities.addBinding().toInstance((Object)DefaultCapabilities.SHARES_CAPABILITY());
        supportedCapabilities.addBinding().toInstance((Object)DefaultCapabilities.VACATION_RESPONSE_CAPABILITY());
        supportedCapabilities.addBinding().toInstance((Object)DefaultCapabilities.SUBMISSION_CAPABILITY());
    }

    @ProvidesIntoSet
    CamelMailetContainerModule.ProcessorsCheck vacationMailetCheck(JMAPConfiguration configuration) {
        if (configuration.isEnabled()) {
            return VACATION_MAILET_CHECK;
        }
        return CamelMailetContainerModule.ProcessorsCheck.noCheck();
    }

    @ProvidesIntoSet
    CamelMailetContainerModule.ProcessorsCheck filteringMailetCheck(JMAPConfiguration configuration) {
        if (configuration.isEnabled()) {
            return FILTERING_MAILET_CHECK;
        }
        return CamelMailetContainerModule.ProcessorsCheck.noCheck();
    }

    @ProvidesIntoSet
    Capability coreCapability(JmapRfc8621Configuration configuration) {
        return DefaultCapabilities.coreCapability((MaxSizeUpload)configuration.maxUploadSize());
    }

    @ProvidesIntoSet
    Capability webSocketCapability(JmapRfc8621Configuration configuration) {
        return DefaultCapabilities.webSocketCapability((URL)configuration.webSocketUrl());
    }

    @Provides
    @Singleton
    JMAPConfiguration provideConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration("jmap");
            return JMAPConfiguration.builder().enabled(configuration.getBoolean("enabled", true)).port(Port.of((int)configuration.getInt("jmap.port", 80))).enableEmailQueryView(Optional.ofNullable(configuration.getBoolean("view.email.query.enabled", null))).defaultVersion(Optional.ofNullable(configuration.getString("jmap.version.default", null)).map(Version::of)).build();
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find JMAP configuration file. JMAP server will not be enabled.");
            return JMAPConfiguration.builder().disable().build();
        }
    }

    @Provides
    @Singleton
    JMAPDraftConfiguration provideDraftConfiguration(PropertiesProvider propertiesProvider, FileSystem fileSystem) throws ConfigurationException, IOException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration("jmap");
            return JMAPDraftConfiguration.builder().enabled(configuration.getBoolean("enabled", true)).keystore(configuration.getString("tls.keystoreURL")).secret(configuration.getString("tls.secret")).jwtPublicKeyPem(this.loadPublicKey(fileSystem, Optional.ofNullable(configuration.getString("jwt.publickeypem.url")))).build();
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find JMAP configuration file. JMAP server will not be enabled.");
            return JMAPDraftConfiguration.builder().disable().build();
        }
    }

    @Provides
    @Singleton
    @Named(value="jmap")
    JwtTokenVerifier providesJwtTokenVerifier(JMAPDraftConfiguration jmapConfiguration) {
        JwtConfiguration jwtConfiguration = new JwtConfiguration(jmapConfiguration.getJwtPublicKeyPem());
        return JwtTokenVerifier.create((JwtConfiguration)jwtConfiguration);
    }

    private Optional<String> loadPublicKey(FileSystem fileSystem, Optional<String> jwtPublickeyPemUrl) {
        return jwtPublickeyPemUrl.map(Throwing.function(url -> FileUtils.readFileToString((File)fileSystem.getFile(url), (Charset)StandardCharsets.US_ASCII)));
    }

    @Singleton
    public static class RequiredCapabilitiesStartUpCheck
    implements StartUpCheck {
        public static final String CHECK_NAME = "MailboxCapabilitiesForJMAP";
        private final MailboxManager mailboxManager;

        @Inject
        public RequiredCapabilitiesStartUpCheck(MailboxManager mailboxManager) {
            this.mailboxManager = mailboxManager;
        }

        public StartUpCheck.CheckResult check() {
            EnumSet messageCapabilities = this.mailboxManager.getSupportedMessageCapabilities();
            EnumSet searchCapabilities = this.mailboxManager.getSupportedSearchCapabilities();
            ImmutableList badCheckDescriptions = (ImmutableList)Stream.of(this.badCheckDescription(this.mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Move), "MOVE support in MailboxManager is required by JMAP Module"), this.badCheckDescription(this.mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.ACL), "ACL support in MailboxManager is required by JMAP Module"), this.badCheckDescription(messageCapabilities.contains(MailboxManager.MessageCapabilities.UniqueID), "MessageIdManager is not defined by this Mailbox implementation"), this.badCheckDescription(searchCapabilities.contains(MailboxManager.SearchCapabilities.MultimailboxSearch), "Multimailbox search in MailboxManager is required by JMAP Module"), this.badCheckDescription(searchCapabilities.contains(MailboxManager.SearchCapabilities.Attachment), "Attachment Search support in MailboxManager is required by JMAP Module"), this.badCheckDescription(searchCapabilities.contains(MailboxManager.SearchCapabilities.AttachmentFileName), "Attachment file name Search support in MailboxManager is required by JMAP Module")).flatMap(Optional::stream).collect(Guavate.toImmutableList());
            if (!badCheckDescriptions.isEmpty()) {
                return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.BAD).description(Joiner.on((String)",").join((Iterable)badCheckDescriptions)).build();
            }
            return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.GOOD).build();
        }

        private Optional<String> badCheckDescription(boolean expressionResult, String expressionFailsDescription) {
            if (expressionResult) {
                return Optional.empty();
            }
            return Optional.ofNullable(expressionFailsDescription);
        }

        public String checkName() {
            return CHECK_NAME;
        }
    }
}

