/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.api;

import com.google.common.io.ByteSource;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.ObjectNotFoundException;
import org.apache.james.blob.api.ObjectStoreIOException;
import org.reactivestreams.Publisher;

public interface BlobStoreDAO {
    public InputStream read(BucketName var1, BlobId var2) throws ObjectStoreIOException, ObjectNotFoundException;

    public Publisher<byte[]> readBytes(BucketName var1, BlobId var2);

    public Publisher<Void> save(BucketName var1, BlobId var2, byte[] var3);

    public Publisher<Void> save(BucketName var1, BlobId var2, InputStream var3);

    public Publisher<Void> save(BucketName var1, BlobId var2, ByteSource var3);

    default public Publisher<Void> save(BucketName bucketName, BlobId blobId, String data) {
        return this.save(bucketName, blobId, data.getBytes(StandardCharsets.UTF_8));
    }

    public Publisher<Void> delete(BucketName var1, BlobId var2);

    public Publisher<Void> deleteBucket(BucketName var1);
}

