/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.utils.DelegatedPropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.apache.james.CONFIGURATION");
    private static final char COMMA = ',';
    private static final String COMMA_STRING = ",";
    private final FileSystem fileSystem;
    private final Configuration.ConfigurationPath configurationPrefix;

    @Inject
    public PropertiesProvider(FileSystem fileSystem, Configuration.ConfigurationPath configurationPrefix) {
        this.fileSystem = fileSystem;
        this.configurationPrefix = configurationPrefix;
    }

    public Configuration getConfigurations(String ... filenames) throws FileNotFoundException, ConfigurationException {
        File file = (File)Arrays.stream(filenames).map(this::getConfigurationFile).flatMap(Optional::stream).findFirst().orElseThrow(() -> new FileNotFoundException(Joiner.on((String)COMMA_STRING).join((Object[])filenames) + " not found"));
        return this.getConfiguration(file);
    }

    public Configuration getConfiguration(String fileName) throws FileNotFoundException, ConfigurationException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fileName) ? 1 : 0) != 0);
        File file = this.getConfigurationFile(fileName).orElseThrow(() -> new FileNotFoundException(fileName));
        return this.getConfiguration(file);
    }

    private Configuration getConfiguration(File propertiesFile) throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)new Parameters().fileBased().setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))).setFile(propertiesFile)});
        return new DelegatedPropertiesConfiguration(COMMA_STRING, (Configuration)builder.getConfiguration());
    }

    private Optional<File> getConfigurationFile(String fileName) {
        try {
            File file = this.fileSystem.getFile(this.configurationPrefix.asString() + fileName + ".properties");
            LOGGER.info("Load configuration file {}", (Object)file.getAbsolutePath());
            return Optional.of(file).filter(File::exists);
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }
}

