/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.json;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.james.json.DTO;
import org.apache.james.json.DTOModule;

public class DTOConverter<T, U extends DTO> {
    private final Map<String, DTOModule<? extends T, ? extends U>> typeToModule;
    private final Map<Class<? extends T>, DTOModule<? extends T, ? extends U>> domainClassToModule;

    @SafeVarargs
    public static <T, U extends DTO> DTOConverter<T, U> of(DTOModule<? extends T, ? extends U> ... modules) {
        return new DTOConverter<T, U>(ImmutableSet.copyOf((Object[])modules));
    }

    public DTOConverter(Set<? extends DTOModule<? extends T, ? extends U>> modules) {
        this.typeToModule = (Map)modules.stream().collect(Guavate.toImmutableMap(DTOModule::getDomainObjectType, Function.identity()));
        this.domainClassToModule = (Map)modules.stream().collect(Guavate.toImmutableMap(DTOModule::getDomainObjectClass, Function.identity()));
    }

    public Optional<U> toDTO(T domainObject) {
        return Optional.ofNullable(this.domainClassToModule.get(domainObject.getClass())).map(module -> module).map(module -> module.toDTO(domainObject));
    }

    public Optional<T> toDomainObject(U dto) {
        String type = dto.getType();
        return Optional.ofNullable(this.typeToModule.get(type)).map(module -> module).map(DTOModule::getToDomainObjectConverter).map(convert -> convert.convert(dto));
    }
}

