/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.model;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.quota.model.QuotaThreshold;

public class QuotaThresholds {
    private final ImmutableList<QuotaThreshold> quotaThresholds;

    public QuotaThresholds(QuotaThreshold ... thresholds) {
        this(Arrays.asList(thresholds));
    }

    public QuotaThresholds(List<QuotaThreshold> quotaThresholds) {
        this.quotaThresholds = (ImmutableList)quotaThresholds.stream().sorted(Comparator.comparing(QuotaThreshold::getQuotaOccupationRatio).reversed()).collect(Guavate.toImmutableList());
    }

    public QuotaThreshold highestExceededThreshold(Quota<?, ?> quota) {
        return this.quotaThresholds.stream().filter(quotaLevel -> quotaLevel.isExceeded(quota)).findFirst().orElse(QuotaThreshold.ZERO);
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaThresholds) {
            QuotaThresholds that = (QuotaThresholds)o;
            return Objects.equals(this.quotaThresholds, that.quotaThresholds);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.quotaThresholds);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("quotaThresholds", this.quotaThresholds).toString();
    }
}

