/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableSet;
import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.SameSourceAndDestinationException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.webadmin.dto.DomainAliasResponse;

public class DomainAliasService {
    private final RecipientRewriteTable recipientRewriteTable;
    private final DomainList domainList;

    @Inject
    public DomainAliasService(RecipientRewriteTable recipientRewriteTable, DomainList domainList) {
        this.recipientRewriteTable = recipientRewriteTable;
        this.domainList = domainList;
    }

    public void removeCorrespondingDomainAliases(Domain domain) throws RecipientRewriteTableException {
        MappingSource mappingSource = MappingSource.fromDomain((Domain)domain);
        this.recipientRewriteTable.getStoredMappings(mappingSource).asStream().forEach(Throwing.consumer(mapping -> this.recipientRewriteTable.removeMapping(mappingSource, mapping)).sneakyThrow());
    }

    public ImmutableSet<DomainAliasResponse> listDomainAliases(Domain domain) throws RecipientRewriteTableException {
        return (ImmutableSet)this.recipientRewriteTable.listSources(Mapping.domainAlias((Domain)domain)).map(DomainAliasResponse::new).collect(Guavate.toImmutableSet());
    }

    public boolean hasAliases(Domain domain) throws DomainListException, RecipientRewriteTableException {
        return this.domainList.containsDomain(domain) || this.recipientRewriteTable.listSources(Mapping.domainAlias((Domain)domain)).findFirst().isPresent();
    }

    public void addDomainAlias(Domain sourceDomain, Domain destinationDomain) throws DomainListException, RecipientRewriteTableException {
        this.performOperationOnAlias((arg_0, arg_1) -> ((RecipientRewriteTable)this.recipientRewriteTable).addMapping(arg_0, arg_1), sourceDomain, destinationDomain);
    }

    public void removeDomainAlias(Domain sourceDomain, Domain destinationDomain) throws DomainListException, RecipientRewriteTableException {
        this.performOperationOnAlias((arg_0, arg_1) -> ((RecipientRewriteTable)this.recipientRewriteTable).removeMapping(arg_0, arg_1), sourceDomain, destinationDomain);
    }

    private void performOperationOnAlias(MappingOperation operation, Domain sourceDomain, Domain destinationDomain) throws DomainListException, RecipientRewriteTableException {
        if (!this.domainList.containsDomain(sourceDomain)) {
            throw new DomainNotFound(sourceDomain);
        }
        this.checkSameSourceAndDestination(sourceDomain, destinationDomain);
        operation.perform(MappingSource.fromDomain((Domain)sourceDomain), Mapping.domainAlias((Domain)destinationDomain));
    }

    private void checkSameSourceAndDestination(Domain source, Domain destination) throws RecipientRewriteTableException {
        if (source.equals((Object)destination)) {
            throw new SameSourceAndDestinationException("Source and destination domain can't be the same!");
        }
    }

    @FunctionalInterface
    static interface MappingOperation {
        public void perform(MappingSource var1, Mapping var2) throws RecipientRewriteTableException;
    }

    public static class DomainNotFound
    extends RuntimeException {
        private final Domain domain;

        DomainNotFound(Domain domain) {
            this.domain = domain;
        }

        public Domain getDomain() {
            return this.domain;
        }
    }
}

