/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.fasterxml.jackson.databind.Module;
import com.github.steveash.guavate.Guavate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.InvalidUsernameException;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.AddUserRequest;
import org.apache.james.webadmin.dto.UserResponse;
import org.apache.james.webadmin.service.UserService;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractException;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;
import spark.Spark;

@Api(tags={"Users"})
@Path(value="/users")
@Produces(value={"application/json"})
public class UserRoutes
implements Routes {
    private static final String USER_NAME = ":userName";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserRoutes.class);
    public static final String USERS = "/users";
    private static final String FORCE_PARAM = "force";
    private final UserService userService;
    private final JsonTransformer jsonTransformer;
    private final CanSendFrom canSendFrom;
    private final JsonExtractor<AddUserRequest> jsonExtractor;
    private Service service;

    @Inject
    public UserRoutes(UserService userService, CanSendFrom canSendFrom, JsonTransformer jsonTransformer) {
        this.userService = userService;
        this.jsonTransformer = jsonTransformer;
        this.canSendFrom = canSendFrom;
        this.jsonExtractor = new JsonExtractor(AddUserRequest.class, new Module[0]);
    }

    public String getBasePath() {
        return USERS;
    }

    public void define(Service service) {
        this.service = service;
        this.defineGetUsers();
        this.defineCreateUser();
        this.defineDeleteUser();
        this.defineAllowedFromHeaders();
        this.defineUserExist();
    }

    @DELETE
    @Path(value="/{username}")
    @ApiOperation(value="Deleting an user")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="username", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. User is removed."), @ApiResponse(code=400, message="Invalid input user."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineDeleteUser() {
        this.service.delete("/users/:userName", this::removeUser);
    }

    @HEAD
    @Path(value="/{username}")
    @ApiOperation(value="Testing an user existence")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="username", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK. User exists."), @ApiResponse(code=400, message="Invalid input user."), @ApiResponse(code=404, message="User does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineUserExist() {
        this.service.head("/users/:userName", this::userExist);
    }

    @PUT
    @Path(value="/{username}")
    @ApiOperation(value="Creating an user")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="username", paramType="path"), @ApiImplicitParam(required=true, dataTypeClass=AddUserRequest.class, paramType="body"), @ApiImplicitParam(paramType="query parameter", dataType="String", allowEmptyValue=true, example="?force", value="If present, it allows to overwrite a user password. Otherwise modification of already existing users are rejected.")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. New user is added."), @ApiResponse(code=400, message="Invalid input user."), @ApiResponse(code=409, message="User already exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineCreateUser() {
        this.service.put("/users/:userName", this::upsertUser);
    }

    @GET
    @ApiOperation(value="Getting all users")
    @ApiResponses(value={@ApiResponse(code=204, message="OK.", response=UserResponse.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetUsers() {
        this.service.get(USERS, (request, response) -> this.userService.getUsers(), (ResponseTransformer)this.jsonTransformer);
    }

    @GET
    @Path(value="/{username}/allowedFromHeaders")
    @ApiOperation(value="List all possible From header value for an existing user")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="username", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK.", response=List.class), @ApiResponse(code=400, message="user is not valid."), @ApiResponse(code=404, message="user does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineAllowedFromHeaders() {
        this.service.get("/users/:userName/allowedFromHeaders", this::allowedFromHeaders, (ResponseTransformer)this.jsonTransformer);
    }

    private String removeUser(Request request, Response response) {
        Username username = this.extractUsername(request);
        try {
            this.userService.removeUser(username);
            return Responses.returnNoContent((Response)response);
        }
        catch (UsersRepositoryException e) {
            throw ErrorResponder.builder().statusCode(204).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("The user " + username + " does not exists").cause((Exception)((Object)e)).haltError();
        }
    }

    private String userExist(Request request, Response response) throws UsersRepositoryException {
        Username username = this.extractUsername(request);
        if (this.userService.userExists(username)) {
            response.status(200);
        } else {
            response.status(404);
        }
        return "";
    }

    private HaltException upsertUser(Request request, Response response) throws JsonExtractException {
        Username username = this.extractUsername(request);
        try {
            boolean isForced = request.queryParams().contains(FORCE_PARAM);
            if (isForced) {
                this.userService.upsertUser(username, ((AddUserRequest)this.jsonExtractor.parse(request.body())).getPassword());
            } else {
                this.userService.insertUser(username, ((AddUserRequest)this.jsonExtractor.parse(request.body())).getPassword());
            }
            return Spark.halt((int)204);
        }
        catch (InvalidUsernameException e) {
            LOGGER.info("Invalid username", (Throwable)e);
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Username supplied is invalid").cause((Exception)((Object)e)).haltError();
        }
        catch (AlreadyExistInUsersRepositoryException e) {
            LOGGER.info(e.getMessage());
            throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("User already exists").cause((Exception)((Object)e)).haltError();
        }
        catch (UsersRepositoryException e) {
            String errorMessage = String.format("Error while upserting user '%s'", username);
            LOGGER.info(errorMessage, (Throwable)e);
            throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message(errorMessage).cause((Exception)((Object)e)).haltError();
        }
    }

    private List<String> allowedFromHeaders(Request request, Response response) {
        Username username = this.extractUsername(request);
        try {
            if (!this.userService.userExists(username)) {
                LOGGER.info("Allowed FROM headers requested for an unknown user: '{}", (Object)username.asString());
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(String.format("user '%s' does not exist", username.asString())).haltError();
            }
            return (List)this.canSendFrom.allValidFromAddressesForUser(username).map(MailAddress::asString).collect(Guavate.toImmutableList());
        }
        catch (RecipientRewriteTable.ErrorMappingException | RecipientRewriteTableException | UsersRepositoryException e) {
            String errorMessage = String.format("Error while listing allowed From headers for user '%s'", username);
            LOGGER.info(errorMessage, e);
            throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message(errorMessage).cause((Exception)e).haltError();
        }
    }

    private Username extractUsername(Request request) {
        return Username.of((String)request.params(USER_NAME));
    }
}

