/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.LoopDetectedException;
import org.apache.james.rrt.api.MappingAlreadyExistsException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.SourceDomainIsNotInDomainListException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.routes.MailAddressParser;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;
import spark.Spark;

@Api(tags={"Address Groups"})
@Path(value="address/groups")
@Produces(value={"application/json"})
public class GroupsRoutes
implements Routes {
    public static final String ROOT_PATH = "address/groups";
    private static final String GROUP_ADDRESS = "groupAddress";
    private static final String GROUP_ADDRESS_PATH = "address/groups/:groupAddress";
    private static final String USER_ADDRESS = "userAddress";
    private static final String USER_IN_GROUP_ADDRESS_PATH = "address/groups/:groupAddress/:userAddress";
    private static final String MAILADDRESS_ASCII_DISCLAIMER = "Note that email addresses are restricted to ASCII character set. Mail addresses not matching this criteria will be rejected.";
    private static final String GROUP_ADDRESS_TYPE = "group";
    private static final String USER_ADDRESS_TYPE = "group member";
    private final UsersRepository usersRepository;
    private final JsonTransformer jsonTransformer;
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    @VisibleForTesting
    GroupsRoutes(RecipientRewriteTable recipientRewriteTable, UsersRepository usersRepository, JsonTransformer jsonTransformer) {
        this.usersRepository = usersRepository;
        this.jsonTransformer = jsonTransformer;
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        service.get(ROOT_PATH, this::listGroups, (ResponseTransformer)this.jsonTransformer);
        service.get(GROUP_ADDRESS_PATH, this::listGroupMembers, (ResponseTransformer)this.jsonTransformer);
        service.put(GROUP_ADDRESS_PATH, (request, response) -> Spark.halt((int)400));
        service.put(USER_IN_GROUP_ADDRESS_PATH, this::addToGroup);
        service.delete(GROUP_ADDRESS_PATH, (request, response) -> Spark.halt((int)400));
        service.delete(USER_IN_GROUP_ADDRESS_PATH, this::removeFromGroup);
    }

    @GET
    @Path(value="address/groups")
    @ApiOperation(value="getting groups list")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public List<MappingSource> listGroups(Request request, Response response) throws RecipientRewriteTableException {
        return (List)this.recipientRewriteTable.getSourcesForType(Mapping.Type.Group).collect(Guavate.toImmutableList());
    }

    @PUT
    @Path(value="address/groups/{groupAddress}/{userAddress}")
    @ApiOperation(value="adding a member into a group")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="groupAddress", paramType="path", value="Mail address of the group. Sending a mail to that address will send it to all group members.\nNote that email addresses are restricted to ASCII character set. Mail addresses not matching this criteria will be rejected."), @ApiImplicitParam(required=true, dataType="string", name="userAddress", paramType="path", value="Mail address of the group. Sending a mail to the group mail address will send an email to that email address (as well as other members).\nNote that email addresses are restricted to ASCII character set. Mail addresses not matching this criteria will be rejected.")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK", response=List.class), @ApiResponse(code=400, message="groupAddress or userAddress format is not valid"), @ApiResponse(code=400, message="Domain in the source is not managed by the DomainList"), @ApiResponse(code=409, message="requested group address is already used for another purpose"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public HaltException addToGroup(Request request, Response response) throws UsersRepositoryException {
        MailAddress groupAddress = MailAddressParser.parseMailAddress(request.params(GROUP_ADDRESS), GROUP_ADDRESS_TYPE);
        Domain domain = groupAddress.getDomain();
        this.ensureNotShadowingAnotherAddress(groupAddress);
        MailAddress userAddress = MailAddressParser.parseMailAddress(request.params(USER_ADDRESS), USER_ADDRESS_TYPE);
        MappingSource source = MappingSource.fromUser((Username)Username.fromLocalPartWithDomain((String)groupAddress.getLocalPart(), (Domain)domain));
        this.addGroupMember(source, userAddress);
        return Spark.halt((int)204);
    }

    private void addGroupMember(MappingSource source, MailAddress userAddress) {
        try {
            this.recipientRewriteTable.addGroupMapping(source, userAddress.asString());
        }
        catch (MappingAlreadyExistsException mappingAlreadyExistsException) {
        }
        catch (SourceDomainIsNotInDomainListException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(e.getMessage()).haltError();
        }
        catch (LoopDetectedException e) {
            throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.WRONG_STATE).message(e.getMessage()).haltError();
        }
        catch (RecipientRewriteTableException e) {
            throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message(e.getMessage()).haltError();
        }
    }

    private void ensureNotShadowingAnotherAddress(MailAddress groupAddress) throws UsersRepositoryException {
        if (this.usersRepository.contains(this.usersRepository.getUsername(groupAddress))) {
            throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Requested group address is already used for another purpose").haltError();
        }
    }

    @DELETE
    @Path(value="address/groups/{groupAddress}/{userAddress}")
    @ApiOperation(value="remove a member from a group")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="groupAddress", paramType="path"), @ApiImplicitParam(required=true, dataType="string", name="userAddress", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=400, message="groupAddress or userAddress format is not valid"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public HaltException removeFromGroup(Request request, Response response) throws RecipientRewriteTableException {
        MailAddress groupAddress = MailAddressParser.parseMailAddress(request.params(GROUP_ADDRESS), GROUP_ADDRESS_TYPE);
        MailAddress userAddress = MailAddressParser.parseMailAddress(request.params(USER_ADDRESS), USER_ADDRESS_TYPE);
        MappingSource source = MappingSource.fromUser((Username)Username.fromLocalPartWithDomain((String)groupAddress.getLocalPart(), (Domain)groupAddress.getDomain()));
        this.recipientRewriteTable.removeGroupMapping(source, userAddress.asString());
        return Spark.halt((int)204);
    }

    @GET
    @Path(value="address/groups/{groupAddress}")
    @ApiOperation(value="listing group members")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="groupAddress", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=400, message="The group is not an address"), @ApiResponse(code=404, message="The group does not exist"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public ImmutableSortedSet<String> listGroupMembers(Request request, Response response) throws RecipientRewriteTableException {
        MailAddress groupAddress = MailAddressParser.parseMailAddress(request.params(GROUP_ADDRESS), GROUP_ADDRESS_TYPE);
        Mappings mappings = this.recipientRewriteTable.getStoredMappings(MappingSource.fromMailAddress((MailAddress)groupAddress)).select(Mapping.Type.Group);
        this.ensureNonEmptyMappings(mappings);
        return (ImmutableSortedSet)mappings.asStream().map(Mapping::asMailAddress).flatMap(Optional::stream).map(MailAddress::asString).collect(Guavate.toImmutableSortedSet());
    }

    private void ensureNonEmptyMappings(Mappings mappings) {
        if (mappings == null || mappings.isEmpty()) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("The group does not exist").haltError();
        }
    }
}

