/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.core.Domain;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.SourceDomainIsNotInDomainListException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;
import spark.Spark;

@Api(tags={"Domain Mappings"})
@Path(value="/domainMappings")
@Produces(value={"application/json"})
public class DomainMappingsRoutes
implements Routes {
    public static final String DOMAIN_MAPPINGS = "/domainMappings";
    private static final String FROM_DOMAIN = "fromDomain";
    private static final String SPECIFIC_MAPPING_PATH = "//{fromDomain}";
    private static final String SPECIFIC_MAPPING = "/domainMappings/:fromDomain";
    private final RecipientRewriteTable recipientRewriteTable;
    private final JsonTransformer jsonTransformer;

    @Inject
    @VisibleForTesting
    DomainMappingsRoutes(RecipientRewriteTable recipientRewriteTable, JsonTransformer jsonTransformer) {
        this.recipientRewriteTable = recipientRewriteTable;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return DOMAIN_MAPPINGS;
    }

    public void define(Service service) {
        service.get(DOMAIN_MAPPINGS, this::getAllMappings, (ResponseTransformer)this.jsonTransformer);
        service.get(SPECIFIC_MAPPING, this::getMapping, (ResponseTransformer)this.jsonTransformer);
        service.put(SPECIFIC_MAPPING, this::addDomainMapping);
        service.delete(SPECIFIC_MAPPING, this::removeDomainMapping);
    }

    @PUT
    @Path(value="//{fromDomain}")
    @ApiOperation(value="Creating domain mapping between source and destination domains.")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="fromDomain", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=204, message="Ok"), @ApiResponse(code=400, message="Domain name is invalid"), @ApiResponse(code=400, message="Domain in the source is not managed by the DomainList"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public HaltException addDomainMapping(Request request, Response response) throws RecipientRewriteTableException {
        MappingSource mappingSource = this.mappingSourceFrom(request);
        Domain destinationDomain = this.extractDomain(request.body());
        this.addAliasDomainMapping(mappingSource, destinationDomain);
        return Spark.halt((int)204);
    }

    private void addAliasDomainMapping(MappingSource source, Domain destinationDomain) throws RecipientRewriteTableException {
        try {
            this.recipientRewriteTable.addDomainAliasMapping(source, destinationDomain);
        }
        catch (SourceDomainIsNotInDomainListException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(e.getMessage()).haltError();
        }
    }

    @DELETE
    @Path(value="//{fromDomain}")
    @ApiOperation(value="Removes domain mapping between source and destination domains.")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="fromDomain", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=204, message="Ok"), @ApiResponse(code=400, message="Domain name is invalid"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public HaltException removeDomainMapping(Request request, Response response) throws RecipientRewriteTableException {
        MappingSource mappingSource = this.mappingSourceFrom(request);
        Domain destinationDomain = this.extractDomain(request.body());
        this.recipientRewriteTable.removeDomainMapping(mappingSource, destinationDomain);
        return Spark.halt((int)204);
    }

    @GET
    @Path(value="/domainMappings")
    @ApiOperation(value="Lists all domain mappings.")
    @ApiResponses(value={@ApiResponse(code=200, message="Domain mappings.", responseContainer="Map"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public Map<String, List<String>> getAllMappings(Request request, Response response) throws RecipientRewriteTableException {
        return (Map)this.recipientRewriteTable.getAllMappings().entrySet().stream().filter(mappingsEntry -> ((Mappings)mappingsEntry.getValue()).contains(Mapping.Type.Domain)).collect(Guavate.toImmutableMap(mappingsEntry -> ((MappingSource)mappingsEntry.getKey()).getFixedDomain(), mappingsEntry -> this.toDomainList((Mappings)mappingsEntry.getValue())));
    }

    @GET
    @Path(value="//{fromDomain}")
    @ApiOperation(value="Lists mappings for specific domain.")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="fromDomain", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Domain mappings.", responseContainer="List"), @ApiResponse(code=400, message="Domain name is invalid"), @ApiResponse(code=404, message="Not existing mappings."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public List<String> getMapping(Request request, Response response) throws RecipientRewriteTableException {
        MappingSource mappingSource = this.mappingSourceFrom(request);
        return Optional.of(this.recipientRewriteTable.getStoredMappings(mappingSource).select(Mapping.Type.Domain)).filter(mappings -> mappings.contains(Mapping.Type.Domain)).map(this::toDomainList).orElseThrow(() -> ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message(String.format("Cannot find mappings for %s", mappingSource.getFixedDomain())).haltError());
    }

    private MappingSource mappingSourceFrom(Request request) {
        Domain fromDomain = this.extractDomain(request.params(FROM_DOMAIN));
        return MappingSource.fromDomain((Domain)fromDomain);
    }

    private Domain extractDomain(String domainAsString) {
        try {
            return Domain.of((String)domainAsString.trim());
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(String.format("The domain %s is invalid.", domainAsString)).cause((Exception)e).haltError();
        }
    }

    private List<String> toDomainList(Mappings mappings) {
        return (List)mappings.select(Mapping.Type.Domain).asStream().map(Mapping::asString).map(arg_0 -> ((Mapping.Type)Mapping.Type.Domain).withoutPrefix(arg_0)).collect(Guavate.toImmutableList());
    }
}

