/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import javax.inject.Inject;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.server.core.MailImpl;
import org.apache.james.webadmin.Routes;
import org.apache.mailet.Mail;
import spark.Service;

@Api(tags={"OverWebMailReceiver"})
@Path(value="/mail-transfer-service")
@Produces(value={"application/json"})
public class TransferEmailRoutes
implements Routes {
    public static final String BASE_URL = "/mail-transfer-service";
    private MailQueue queue;

    public String getBasePath() {
        return BASE_URL;
    }

    @Inject
    public TransferEmailRoutes(MailQueueFactory<?> queueFactory) {
        this.queue = queueFactory.createQueue(MailQueueFactory.SPOOL);
    }

    public void define(Service service) {
        this.defineReceiveMailFromWebService(service);
    }

    @POST
    @Path(value="/mail-transfer-service")
    @ApiOperation(value="Receiving a message/rfc822 over REST interface")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="username", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=201, message=""), @ApiResponse(code=400, message="Could not ceate mail from supplied body"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineReceiveMailFromWebService(Service service) {
        service.post(BASE_URL, (request, response) -> {
            MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties()), (InputStream)new ByteArrayInputStream(request.bodyAsBytes()));
            MailImpl mail = MailImpl.fromMimeMessage((String)UUID.randomUUID().toString(), (MimeMessage)mimeMessage);
            this.queue.enQueue((Mail)mail);
            response.body("");
            response.status(201);
            return response.body();
        });
    }
}

