/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RoutesBuilderLoader;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class DefaultRoutesLoader
implements RoutesLoader {
    public static final String ROUTES_LOADER_KEY_PREFIX = "routes-builder-loader-";
    private CamelContext camelContext;

    public DefaultRoutesLoader() {
    }

    public DefaultRoutesLoader(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Collection<RoutesBuilder> findRoutesBuilders(Collection<Resource> resources) throws Exception {
        ArrayList<RoutesBuilder> answer = new ArrayList<RoutesBuilder>(resources.size());
        for (Resource resource : resources) {
            String extension = FileUtil.onlyExt((String)resource.getLocation(), (boolean)true);
            if (ObjectHelper.isEmpty((Object)extension)) {
                throw new IllegalArgumentException("Unable to determine file extension for resource: " + resource.getLocation());
            }
            answer.add(this.getRoutesLoader(extension).loadRoutesBuilder(resource));
        }
        return answer;
    }

    private RoutesBuilderLoader getRoutesLoader(String extension) throws Exception {
        RoutesBuilderLoader answer = (RoutesBuilderLoader)this.getCamelContext().getRegistry().lookupByNameAndType(ROUTES_LOADER_KEY_PREFIX + extension, RoutesBuilderLoader.class);
        if (answer == null) {
            FactoryFinder finder;
            ExtendedCamelContext ecc = (ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class);
            answer = ResolverHelper.resolveService((CamelContext)ecc, (FactoryFinder)(finder = ecc.getBootstrapFactoryFinder("META-INF/services/org/apache/camel/routes-loader/")), (String)extension, RoutesBuilderLoader.class).orElse(null);
            if (answer == null) {
                throw new IllegalArgumentException("Cannot find RoutesBuilderLoader in classpath supporting file extension: " + extension);
            }
            this.getCamelContext().addService((Object)answer);
            this.getCamelContext().getRegistry().bind(ROUTES_LOADER_KEY_PREFIX + extension, (Object)answer);
        }
        return answer;
    }
}

