/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.modules;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.CreateType;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import org.apache.james.backends.cassandra.components.CassandraModule;

public interface CassandraMailboxModule {
    public static final CassandraModule MODULE = CassandraModule.builder().type("mailboxbase").statement(statement -> (CreateType)((CreateType)statement.addColumn("namespace", DataType.text())).addColumn("user", DataType.text())).table("mailbox").comment("Holds the mailboxes information.").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)((Create)((Create)statement.addPartitionKey("id", DataType.timeuuid()).addUDTColumn("mailboxbase", SchemaBuilder.frozen((String)"mailboxbase"))).addColumn("name", DataType.text())).addColumn("uidvalidity", DataType.bigint())).table("mailboxPath").comment("Denormalisation table. Allow to retrieve mailboxes belonging to a certain user. This is a LIST optimisation.").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)statement.addUDTPartitionKey("namespaceAndUser", SchemaBuilder.frozen((String)"mailboxbase")).addClusteringColumn("mailboxName", DataType.text()).addColumn("mailboxId", DataType.timeuuid())).table("mailboxPathV2").comment("Denormalisation table. Allow to retrieve mailboxes belonging to a certain user. This is a LIST optimisation.").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)statement.addPartitionKey("namespace", DataType.text()).addPartitionKey("user", DataType.text()).addClusteringColumn("mailboxName", DataType.text()).addColumn("mailboxId", DataType.timeuuid())).table("mailboxPathV3").comment("Denormalisation table. Allow to retrieve mailboxes belonging to a certain user. This is a LIST optimisation.").options(options -> (Create.Options)options.caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)((Create)statement.addPartitionKey("namespace", DataType.text()).addPartitionKey("user", DataType.text()).addClusteringColumn("mailboxName", DataType.text()).addColumn("mailboxId", DataType.timeuuid())).addColumn("uidvalidity", DataType.bigint())).build();
}

