/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.modules;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.TableOptions;
import org.apache.james.backends.cassandra.components.CassandraModule;

public interface CassandraAttachmentModule {
    public static final CassandraModule MODULE = CassandraModule.table((String)"attachmentV2").comment("Holds attachment for fast attachment retrieval. Content of messages is storedin `blobs` and `blobparts` tables.").options(options -> (Create.Options)((Create.Options)options.compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.sizedTieredStategy())).caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> (Create)((Create)((Create)((Create)statement.addPartitionKey("idAsUUID", DataType.uuid()).addColumn("id", DataType.text())).addColumn("blobId", DataType.text())).addColumn("type", DataType.text())).addColumn("size", DataType.bigint())).table("attachmentMessageId").comment("Holds ids of messages owning the attachment").options(options -> (Create.Options)((Create.Options)options.compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.sizedTieredStategy())).caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> ((Create)statement.addPartitionKey("attachmentIdAsUUID", DataType.uuid()).addColumn("attachmentId", DataType.text())).addClusteringColumn("messageId", DataType.text())).table("attachmentOwners").comment("Holds explicit owners of some attachments").options(options -> (Create.Options)((Create.Options)((Create.Options)options.compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.leveledStrategy())).bloomFilterFPChance(Double.valueOf(0.01))).caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)10))).statement(statement -> statement.addPartitionKey("id", DataType.uuid()).addClusteringColumn("owner", DataType.text())).build();
}

