/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.mailbox.cassandra.mail.task.RecomputeMailboxCountersService;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.scheduler.Schedulers;

public class RecomputeMailboxCountersTask
implements Task {
    public static final Logger LOGGER = LoggerFactory.getLogger(RecomputeMailboxCountersTask.class);
    static final TaskType RECOMPUTE_MAILBOX_COUNTERS = TaskType.of((String)"recompute-mailbox-counters");
    private final RecomputeMailboxCountersService service;
    private final RecomputeMailboxCountersService.Options options;
    private RecomputeMailboxCountersService.Context context;

    public RecomputeMailboxCountersTask(RecomputeMailboxCountersService service, RecomputeMailboxCountersService.Options options) {
        this.service = service;
        this.options = options;
        this.context = new RecomputeMailboxCountersService.Context();
    }

    public Task.Result run() {
        return (Task.Result)this.service.recomputeMailboxCounters(this.context, this.options).subscribeOn(Schedulers.elastic()).block();
    }

    public TaskType type() {
        return RECOMPUTE_MAILBOX_COUNTERS;
    }

    public RecomputeMailboxCountersService.Options getOptions() {
        return this.options;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        RecomputeMailboxCountersService.Context.Snapshot snapshot = this.context.snapshot();
        return Optional.of(new Details(Clock.systemUTC().instant(), snapshot.getProcessedMailboxCount(), (ImmutableList<String>)((ImmutableList)snapshot.getFailedMailboxes().stream().map(MailboxId::serialize).collect(Guavate.toImmutableList()))));
    }

    public static class Details
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant instant;
        private final long processedMailboxes;
        private final ImmutableList<String> failedMailboxes;

        Details(Instant instant, long processedMailboxes, ImmutableList<String> failedMailboxes) {
            this.instant = instant;
            this.processedMailboxes = processedMailboxes;
            this.failedMailboxes = failedMailboxes;
        }

        public Instant timestamp() {
            return this.instant;
        }

        long getProcessedMailboxes() {
            return this.processedMailboxes;
        }

        ImmutableList<String> getFailedMailboxes() {
            return this.failedMailboxes;
        }
    }
}

