/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.eventsourcing.acl;

import java.util.stream.Stream;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.mailbox.cassandra.mail.CassandraACLDAOV2;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.ACLUpdated;
import org.apache.james.mailbox.model.MailboxACL;
import reactor.core.publisher.Flux;

public class AclV2DAOSubscriber
implements Subscriber {
    private final CassandraACLDAOV2 acldaov2;

    public AclV2DAOSubscriber(CassandraACLDAOV2 acldaov2) {
        this.acldaov2 = acldaov2;
    }

    public void handle(Event event) {
        if (event instanceof ACLUpdated) {
            ACLUpdated aclUpdated = (ACLUpdated)event;
            Flux.fromStream((Stream)aclUpdated.getAclDiff().commands()).flatMap(command -> this.acldaov2.updateACL(aclUpdated.mailboxId(), (MailboxACL.ACLCommand)command)).blockLast();
        }
    }
}

