/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.FlagsExtractor;
import org.apache.james.mailbox.cassandra.table.MessageIdToImapUid;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMessageIdToImapUidDAO {
    private static final String MOD_SEQ_CONDITION = "modSeqCondition";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final CassandraMessageId.Factory messageIdFactory;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement update;
    private final PreparedStatement selectAll;
    private final PreparedStatement select;
    private final PreparedStatement listStatement;
    private final CassandraConsistenciesConfiguration consistenciesConfiguration;

    @Inject
    public CassandraMessageIdToImapUidDAO(Session session, CassandraConsistenciesConfiguration consistenciesConfiguration, CassandraMessageId.Factory messageIdFactory) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.consistenciesConfiguration = consistenciesConfiguration;
        this.messageIdFactory = messageIdFactory;
        this.delete = this.prepareDelete(session);
        this.insert = this.prepareInsert(session);
        this.update = this.prepareUpdate(session);
        this.selectAll = this.prepareSelectAll(session);
        this.select = this.prepareSelect(session);
        this.listStatement = this.prepareList(session);
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("imapUidTable").where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))).and(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"imapUidTable").value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).value("uid", (Object)QueryBuilder.bindMarker((String)"uid")).value("modSeq", (Object)QueryBuilder.bindMarker((String)"modSeq")).value("flagAnswered", (Object)QueryBuilder.bindMarker((String)"flagAnswered")).value("flagDeleted", (Object)QueryBuilder.bindMarker((String)"flagDeleted")).value("flagDraft", (Object)QueryBuilder.bindMarker((String)"flagDraft")).value("flagFlagged", (Object)QueryBuilder.bindMarker((String)"flagFlagged")).value("flagRecent", (Object)QueryBuilder.bindMarker((String)"flagRecent")).value("flagSeen", (Object)QueryBuilder.bindMarker((String)"flagSeen")).value("flagUser", (Object)QueryBuilder.bindMarker((String)"flagUser")).value("userFlags", (Object)QueryBuilder.bindMarker((String)"userFlags")).ifNotExists());
    }

    private PreparedStatement prepareUpdate(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"imapUidTable").with(QueryBuilder.set((String)"modSeq", (Object)QueryBuilder.bindMarker((String)"modSeq"))).and(QueryBuilder.set((String)"flagAnswered", (Object)QueryBuilder.bindMarker((String)"flagAnswered"))).and(QueryBuilder.set((String)"flagDeleted", (Object)QueryBuilder.bindMarker((String)"flagDeleted"))).and(QueryBuilder.set((String)"flagDraft", (Object)QueryBuilder.bindMarker((String)"flagDraft"))).and(QueryBuilder.set((String)"flagFlagged", (Object)QueryBuilder.bindMarker((String)"flagFlagged"))).and(QueryBuilder.set((String)"flagRecent", (Object)QueryBuilder.bindMarker((String)"flagRecent"))).and(QueryBuilder.set((String)"flagSeen", (Object)QueryBuilder.bindMarker((String)"flagSeen"))).and(QueryBuilder.set((String)"flagUser", (Object)QueryBuilder.bindMarker((String)"flagUser"))).and(QueryBuilder.set((String)"userFlags", (Object)QueryBuilder.bindMarker((String)"userFlags"))).where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))).and(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))).onlyIf(QueryBuilder.eq((String)"modSeq", (Object)QueryBuilder.bindMarker((String)MOD_SEQ_CONDITION))));
    }

    private PreparedStatement prepareSelectAll(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])MessageIdToImapUid.FIELDS).from("imapUidTable").where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
    }

    private PreparedStatement prepareList(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])MessageIdToImapUid.FIELDS).from("imapUidTable"));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])MessageIdToImapUid.FIELDS).from("imapUidTable").where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))).and(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    public Mono<Void> delete(CassandraMessageId messageId, CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setUUID("messageId", messageId.get()).setUUID("mailboxId", mailboxId.asUuid()));
    }

    public Mono<Void> insert(ComposedMessageIdWithMetaData composedMessageIdWithMetaData) {
        ComposedMessageId composedMessageId = composedMessageIdWithMetaData.getComposedMessageId();
        Flags flags = composedMessageIdWithMetaData.getFlags();
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insert.bind().setUUID("messageId", ((CassandraMessageId)composedMessageId.getMessageId()).get()).setUUID("mailboxId", ((CassandraId)composedMessageId.getMailboxId()).asUuid()).setLong("uid", composedMessageId.getUid().asLong()).setLong("modSeq", composedMessageIdWithMetaData.getModSeq().asLong()).setBool("flagAnswered", flags.contains(Flags.Flag.ANSWERED)).setBool("flagDeleted", flags.contains(Flags.Flag.DELETED)).setBool("flagDraft", flags.contains(Flags.Flag.DRAFT)).setBool("flagFlagged", flags.contains(Flags.Flag.FLAGGED)).setBool("flagRecent", flags.contains(Flags.Flag.RECENT)).setBool("flagSeen", flags.contains(Flags.Flag.SEEN)).setBool("flagUser", flags.contains(Flags.Flag.USER)).setSet("userFlags", (Set)ImmutableSet.copyOf((Object[])flags.getUserFlags())));
    }

    public Mono<Boolean> updateMetadata(ComposedMessageIdWithMetaData composedMessageIdWithMetaData, ModSeq oldModSeq) {
        ComposedMessageId composedMessageId = composedMessageIdWithMetaData.getComposedMessageId();
        Flags flags = composedMessageIdWithMetaData.getFlags();
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)this.update.bind().setLong("modSeq", composedMessageIdWithMetaData.getModSeq().asLong()).setBool("flagAnswered", flags.contains(Flags.Flag.ANSWERED)).setBool("flagDeleted", flags.contains(Flags.Flag.DELETED)).setBool("flagDraft", flags.contains(Flags.Flag.DRAFT)).setBool("flagFlagged", flags.contains(Flags.Flag.FLAGGED)).setBool("flagRecent", flags.contains(Flags.Flag.RECENT)).setBool("flagSeen", flags.contains(Flags.Flag.SEEN)).setBool("flagUser", flags.contains(Flags.Flag.USER)).setSet("userFlags", (Set)ImmutableSet.copyOf((Object[])flags.getUserFlags())).setUUID("messageId", ((CassandraMessageId)composedMessageId.getMessageId()).get()).setUUID("mailboxId", ((CassandraId)composedMessageId.getMailboxId()).asUuid()).setLong("uid", composedMessageId.getUid().asLong()).setLong(MOD_SEQ_CONDITION, oldModSeq.asLong()));
    }

    public Flux<ComposedMessageIdWithMetaData> retrieve(CassandraMessageId messageId, Optional<CassandraId> mailboxId, ReadConsistency readConsistency) {
        return this.cassandraAsyncExecutor.executeRows(this.selectStatement(messageId, mailboxId).setConsistencyLevel(readConsistency.choose(this.consistenciesConfiguration))).map(this::toComposedMessageIdWithMetadata);
    }

    @VisibleForTesting
    public Flux<ComposedMessageIdWithMetaData> retrieve(CassandraMessageId messageId, Optional<CassandraId> mailboxId) {
        return this.retrieve(messageId, mailboxId, ReadConsistency.STRONG);
    }

    public Flux<ComposedMessageIdWithMetaData> retrieveAllMessages() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listStatement.bind()).map(row -> this.toComposedMessageIdWithMetadata((Row)row));
    }

    private ComposedMessageIdWithMetaData toComposedMessageIdWithMetadata(Row row) {
        return ComposedMessageIdWithMetaData.builder().composedMessageId(new ComposedMessageId((MailboxId)CassandraId.of(row.getUUID("mailboxId")), (MessageId)CassandraMessageId.Factory.of(row.getUUID("messageId")), MessageUid.of((long)row.getLong("uid")))).flags(FlagsExtractor.getFlags(row)).modSeq(ModSeq.of((long)row.getLong("modSeq"))).build();
    }

    private Statement selectStatement(CassandraMessageId messageId, Optional<CassandraId> mailboxId) {
        return (Statement)mailboxId.map(cassandraId -> this.select.bind().setUUID("messageId", messageId.get()).setUUID("mailboxId", cassandraId.asUuid())).orElseGet(() -> this.selectAll.bind().setUUID("messageId", messageId.get()));
    }

    public static enum ReadConsistency {
        STRONG(CassandraConsistenciesConfiguration::getLightweightTransaction),
        WEAK(CassandraConsistenciesConfiguration::getRegular);

        private final Function<CassandraConsistenciesConfiguration, ConsistencyLevel> consistencyLevelChoice;

        private ReadConsistency(Function<CassandraConsistenciesConfiguration, ConsistencyLevel> consistencyLevelChoice) {
            this.consistencyLevelChoice = consistencyLevelChoice;
        }

        public ConsistencyLevel choose(CassandraConsistenciesConfiguration configuration) {
            return this.consistencyLevelChoice.apply(configuration);
        }
    }
}

