/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentDAOV2;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentOwnerDAO;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ParsedAttachment;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.io.CurrentPositionInputStream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraAttachmentMapper
implements AttachmentMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraAttachmentMapper.class);
    private final CassandraAttachmentDAOV2 attachmentDAOV2;
    private final BlobStore blobStore;
    private final CassandraAttachmentMessageIdDAO attachmentMessageIdDAO;
    private final CassandraAttachmentOwnerDAO ownerDAO;

    @Inject
    public CassandraAttachmentMapper(CassandraAttachmentDAOV2 attachmentDAOV2, BlobStore blobStore, CassandraAttachmentMessageIdDAO attachmentMessageIdDAO, CassandraAttachmentOwnerDAO ownerDAO) {
        this.attachmentDAOV2 = attachmentDAOV2;
        this.blobStore = blobStore;
        this.attachmentMessageIdDAO = attachmentMessageIdDAO;
        this.ownerDAO = ownerDAO;
    }

    public AttachmentMetadata getAttachment(AttachmentId attachmentId) throws AttachmentNotFoundException {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        return (AttachmentMetadata)this.getAttachmentInternal(attachmentId).blockOptional().orElseThrow(() -> new AttachmentNotFoundException(attachmentId.getId()));
    }

    public List<AttachmentMetadata> getAttachments(Collection<AttachmentId> attachmentIds) {
        Preconditions.checkArgument((attachmentIds != null ? 1 : 0) != 0);
        return (List)Flux.fromIterable(attachmentIds).flatMap(this::getAttachmentsAsMono, 16).collect(Guavate.toImmutableList()).block();
    }

    public InputStream loadAttachmentContent(AttachmentId attachmentId) throws AttachmentNotFoundException, IOException {
        return (InputStream)this.attachmentDAOV2.getAttachment(attachmentId).map(daoAttachment -> this.blobStore.read(this.blobStore.getDefaultBucketName(), daoAttachment.getBlobId(), BlobStore.StoragePolicy.LOW_COST)).blockOptional().orElseThrow(() -> new AttachmentNotFoundException(attachmentId.toString()));
    }

    public Mono<AttachmentMetadata> getAttachmentsAsMono(AttachmentId attachmentId) {
        return this.getAttachmentInternal(attachmentId).switchIfEmpty(ReactorUtils.executeAndEmpty(() -> this.logNotFound(attachmentId)));
    }

    private Mono<AttachmentMetadata> getAttachmentInternal(AttachmentId id) {
        return this.attachmentDAOV2.getAttachment(id).map(CassandraAttachmentDAOV2.DAOAttachment::toAttachment);
    }

    public Mono<AttachmentMetadata> storeAttachmentForOwner(ContentType contentType, InputStream inputStream, Username owner) {
        CurrentPositionInputStream currentPositionInputStream = new CurrentPositionInputStream(inputStream);
        AttachmentId attachmentId = AttachmentId.random();
        return this.ownerDAO.addOwner(attachmentId, owner).then(Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), (InputStream)currentPositionInputStream, BlobStore.StoragePolicy.LOW_COST))).map(blobId -> new CassandraAttachmentDAOV2.DAOAttachment(attachmentId, (BlobId)blobId, contentType, currentPositionInputStream.getPosition())).flatMap(this.attachmentDAOV2::storeAttachment).then(Mono.defer(() -> Mono.just((Object)AttachmentMetadata.builder().attachmentId(attachmentId).type(contentType).size(currentPositionInputStream.getPosition()).build())));
    }

    public List<MessageAttachmentMetadata> storeAttachmentsForMessage(Collection<ParsedAttachment> parsedAttachments, MessageId ownerMessageId) throws MailboxException {
        return (List)Flux.fromIterable(parsedAttachments).concatMap(attachment -> this.storeAttachmentAsync((ParsedAttachment)attachment, ownerMessageId)).collectList().block();
    }

    public Collection<MessageId> getRelatedMessageIds(AttachmentId attachmentId) throws MailboxException {
        return (Collection)this.attachmentMessageIdDAO.getOwnerMessageIds(attachmentId).collect(Guavate.toImmutableList()).block();
    }

    public Collection<Username> getOwners(AttachmentId attachmentId) throws MailboxException {
        return (Collection)this.ownerDAO.retrieveOwners(attachmentId).collect(Guavate.toImmutableList()).block();
    }

    private Mono<MessageAttachmentMetadata> storeAttachmentAsync(ParsedAttachment parsedAttachment, MessageId ownerMessageId) {
        try {
            AttachmentId attachmentId = AttachmentId.random();
            ByteSource content = parsedAttachment.getContent();
            long size = content.size();
            return Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), content, BlobStore.StoragePolicy.LOW_COST)).map(blobId -> new CassandraAttachmentDAOV2.DAOAttachment(attachmentId, (BlobId)blobId, parsedAttachment.getContentType(), size)).flatMap(daoAttachment -> this.storeAttachmentWithIndex((CassandraAttachmentDAOV2.DAOAttachment)daoAttachment, ownerMessageId)).then(Mono.defer(() -> Mono.just((Object)parsedAttachment.asMessageAttachment(attachmentId, size))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Mono<Void> storeAttachmentWithIndex(CassandraAttachmentDAOV2.DAOAttachment daoAttachment, MessageId ownerMessageId) {
        return this.attachmentDAOV2.storeAttachment(daoAttachment).then(this.attachmentMessageIdDAO.storeAttachmentForMessageId(daoAttachment.getAttachmentId(), ownerMessageId));
    }

    private void logNotFound(AttachmentId attachmentId) {
        LOGGER.warn("Failed retrieving attachment {}", (Object)attachmentId);
    }
}

