/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraUtils;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.table.CassandraAnnotationTable;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;

public class CassandraAnnotationMapper
extends NonTransactionalMapper
implements AnnotationMapper {
    private final Session session;
    private final CassandraUtils cassandraUtils;

    @Inject
    public CassandraAnnotationMapper(Session session, CassandraUtils cassandraUtils) {
        this.session = session;
        this.cassandraUtils = cassandraUtils;
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxId mailboxId) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.cassandraUtils.convertToStream(this.session.execute((Statement)this.getStoredAnnotationsQuery(cassandraId))).map(this::toAnnotation).collect(Collectors.toList());
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.cassandraUtils.convertToStream(this.session.execute((Statement)this.getStoredAnnotationsQueryForKeys(cassandraId, keys))).map(this::toAnnotation).collect(Collectors.toList());
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        return (List)keys.stream().flatMap(annotation -> this.getAnnotationsByKeyWithOneDepth(cassandraId, (MailboxAnnotationKey)annotation)).collect(Guavate.toImmutableList());
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        return (List)keys.stream().flatMap(annotation -> this.getAnnotationsByKeyWithAllDepth(cassandraId, (MailboxAnnotationKey)annotation)).collect(Guavate.toImmutableList());
    }

    public void deleteAnnotation(MailboxId mailboxId, MailboxAnnotationKey key) {
        this.session.execute((Statement)QueryBuilder.delete().from("annotation").where(QueryBuilder.eq((String)"mailboxId", (Object)((CassandraId)mailboxId).asUuid())).and(QueryBuilder.eq((String)"key", (Object)key.asString())));
    }

    public void insertAnnotation(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        Preconditions.checkArgument((!mailboxAnnotation.isNil() ? 1 : 0) != 0);
        this.session.execute((Statement)QueryBuilder.insertInto((String)"annotation").value("mailboxId", (Object)((CassandraId)mailboxId).asUuid()).value("key", (Object)mailboxAnnotation.getKey().asString()).value("value", mailboxAnnotation.getValue().get()));
    }

    public boolean exist(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        Optional<Row> row = Optional.ofNullable(this.session.execute((Statement)this.getStoredAnnotationsQueryByKey(cassandraId, mailboxAnnotation.getKey().asString())).one());
        return row.isPresent();
    }

    public int countAnnotations(MailboxId mailboxId) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.session.execute((Statement)this.getStoredAnnotationsQuery(cassandraId)).getAvailableWithoutFetching();
    }

    private MailboxAnnotation toAnnotation(Row row) {
        return MailboxAnnotation.newInstance((MailboxAnnotationKey)new MailboxAnnotationKey(row.getString("key")), (String)row.getString("value"));
    }

    private Select.Where getStoredAnnotationsQuery(CassandraId mailboxId) {
        return QueryBuilder.select((String[])CassandraAnnotationTable.SELECT_FIELDS).from("annotation").where(QueryBuilder.eq((String)"mailboxId", (Object)mailboxId.asUuid()));
    }

    private Select.Where getStoredAnnotationsQueryForKeys(CassandraId mailboxId, Set<MailboxAnnotationKey> keys) {
        return this.getStoredAnnotationsQuery(mailboxId).and(QueryBuilder.in((String)"key", (Iterable)((Iterable)keys.stream().map(MailboxAnnotationKey::asString).collect(Guavate.toImmutableList()))));
    }

    private Select.Where getStoredAnnotationsQueryLikeKey(CassandraId mailboxId, String key) {
        return this.getStoredAnnotationsQuery(mailboxId).and(QueryBuilder.gte((String)"key", (Object)key)).and(QueryBuilder.lte((String)"key", (Object)this.buildNextKey(key)));
    }

    private Select.Where getStoredAnnotationsQueryByKey(CassandraId mailboxId, String key) {
        return this.getStoredAnnotationsQuery(mailboxId).and(QueryBuilder.eq((String)"key", (Object)key));
    }

    private String buildNextKey(String key) {
        return key + "/\u007f";
    }

    private Stream<MailboxAnnotation> getAnnotationsByKeyWithAllDepth(CassandraId mailboxId, MailboxAnnotationKey key) {
        return this.cassandraUtils.convertToStream(this.session.execute((Statement)this.getStoredAnnotationsQueryLikeKey(mailboxId, key.asString()))).map(this::toAnnotation).filter(annotation -> key.isAncestorOrIsEqual(annotation.getKey()));
    }

    private Stream<MailboxAnnotation> getAnnotationsByKeyWithOneDepth(CassandraId mailboxId, MailboxAnnotationKey key) {
        return this.cassandraUtils.convertToStream(this.session.execute((Statement)this.getStoredAnnotationsQueryLikeKey(mailboxId, key.asString()))).map(this::toAnnotation).filter(annotation -> key.isParentOrIsEqual(annotation.getKey()));
    }
}

