/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLContext;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.encode.base.ImapResponseComposerImpl;
import org.apache.james.imap.main.ResponseEncoder;
import org.apache.james.imapserver.netty.ChannelImapResponseWriter;
import org.apache.james.imapserver.netty.IMAPMDCContext;
import org.apache.james.imapserver.netty.ImapHeartbeatHandler;
import org.apache.james.imapserver.netty.ImapMetrics;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.imapserver.netty.NettyImapSession;
import org.apache.james.metrics.api.Metric;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelLocal;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImapChannelUpstreamHandler
extends SimpleChannelUpstreamHandler
implements NettyConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImapChannelUpstreamHandler.class);
    private final String hello;
    private final String[] enabledCipherSuites;
    private final SSLContext context;
    private final boolean compress;
    private final ImapProcessor processor;
    private final ImapEncoder encoder;
    private final ImapHeartbeatHandler heartbeatHandler = new ImapHeartbeatHandler();
    private final boolean plainAuthDisallowed;
    private final Metric imapConnectionsMetric;
    private final Metric imapCommandsMetric;

    public ImapChannelUpstreamHandler(String hello, ImapProcessor processor, ImapEncoder encoder, boolean compress, boolean plainAuthDisallowed, ImapMetrics imapMetrics) {
        this(hello, processor, encoder, compress, plainAuthDisallowed, null, null, imapMetrics);
    }

    public ImapChannelUpstreamHandler(String hello, ImapProcessor processor, ImapEncoder encoder, boolean compress, boolean plainAuthDisallowed, SSLContext context, String[] enabledCipherSuites, ImapMetrics imapMetrics) {
        this.hello = hello;
        this.processor = processor;
        this.encoder = encoder;
        this.context = context;
        this.enabledCipherSuites = enabledCipherSuites;
        this.compress = compress;
        this.plainAuthDisallowed = plainAuthDisallowed;
        this.imapConnectionsMetric = imapMetrics.getConnectionsMetric();
        this.imapCommandsMetric = imapMetrics.getCommandsMetric();
    }

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        NettyImapSession imapsession = new NettyImapSession(ctx.getChannel(), this.context, this.enabledCipherSuites, this.compress, this.plainAuthDisallowed, ImapSession.SessionId.generate());
        attributes.set(ctx.getChannel(), (Object)imapsession);
        try (Closeable closeable = IMAPMDCContext.from(ctx, (ChannelLocal<Object>)attributes);){
            super.channelBound(ctx, e);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try (Closeable closeable = IMAPMDCContext.from(ctx, (ChannelLocal<Object>)attributes);){
            InetSocketAddress address = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
            LOGGER.info("Connection closed for {}", (Object)address.getAddress().getHostAddress());
            ImapSession imapSession = (ImapSession)attributes.remove(ctx.getChannel());
            if (imapSession != null) {
                imapSession.logout();
            }
            this.imapConnectionsMetric.decrement();
            super.channelClosed(ctx, e);
        }
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try (Closeable closeable = IMAPMDCContext.from(ctx, (ChannelLocal<Object>)attributes);){
            InetSocketAddress address = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
            LOGGER.info("Connection established from {}", (Object)address.getAddress().getHostAddress());
            this.imapConnectionsMetric.increment();
            ImapResponseComposerImpl response = new ImapResponseComposerImpl((ImapResponseWriter)new ChannelImapResponseWriter(ctx.getChannel()));
            ctx.setAttachment((Object)response);
            response.untagged().message("OK").message(this.hello).end();
            super.channelConnected(ctx, e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        try (Closeable closeable = IMAPMDCContext.from(ctx, (ChannelLocal<Object>)attributes);){
            LOGGER.warn("Error while processing imap request", e.getCause());
            if (e.getCause() instanceof TooLongFrameException) {
                ImapResponseComposer composer = (ImapResponseComposer)ctx.getAttachment();
                composer.untaggedResponse("BAD failed. Maximum command line length exceeded");
            } else {
                Channel channel;
                ImapSession imapSession = (ImapSession)attributes.get(ctx.getChannel());
                if (imapSession != null) {
                    imapSession.logout();
                }
                if ((channel = ctx.getChannel()).isConnected()) {
                    channel.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        try (Closeable closeable = IMAPMDCContext.from(ctx, (ChannelLocal<Object>)attributes);){
            this.imapCommandsMetric.increment();
            ImapSession session = (ImapSession)attributes.get(ctx.getChannel());
            ImapResponseComposer response = (ImapResponseComposer)ctx.getAttachment();
            ImapMessage message = (ImapMessage)event.getMessage();
            ChannelPipeline cp = ctx.getPipeline();
            try {
                IOException failure;
                Channel channel;
                try {
                    if (cp.get("executionHandler") != null) {
                        cp.addBefore("executionHandler", "heartbeatHandler", (ChannelHandler)this.heartbeatHandler);
                    } else {
                        cp.addBefore("coreHandler", "heartbeatHandler", (ChannelHandler)this.heartbeatHandler);
                    }
                }
                catch (IllegalArgumentException e) {
                    LOGGER.info("heartbeat handler is already part of this pipeline", (Throwable)e);
                }
                ResponseEncoder responseEncoder = new ResponseEncoder(this.encoder, response);
                this.processor.process(message, (ImapProcessor.Responder)responseEncoder, session);
                if (session.getState() == ImapSessionState.LOGOUT && (channel = ctx.getChannel()).isConnected()) {
                    channel.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
                }
                if ((failure = responseEncoder.getFailure()) != null) {
                    LOGGER.info(failure.getMessage());
                    LOGGER.debug("Failed to write {}", (Object)message, (Object)failure);
                    throw failure;
                }
            }
            finally {
                try {
                    ctx.getPipeline().remove("heartbeatHandler");
                }
                catch (NoSuchElementException e) {
                    LOGGER.info("Heartbeat handler was concurrently removed");
                }
                if (message instanceof Closeable) {
                    ((Closeable)message).close();
                }
            }
            super.messageReceived(ctx, event);
        }
    }
}

