/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Client;

final class NioUdpClient
extends Client {
    private static final Logger log = LoggerFactory.getLogger(NioUdpClient.class);
    private static final int EPHEMERAL_START;
    private static final int EPHEMERAL_RANGE;
    private static final SecureRandom prng;
    private static final Queue<Transaction> registrationQueue;
    private static final Queue<Transaction> pendingTransactions;

    private static void processPendingRegistrations() {
        while (!registrationQueue.isEmpty()) {
            Transaction t = registrationQueue.remove();
            try {
                t.channel.register(NioUdpClient.selector(), 1, t);
                t.send();
            }
            catch (IOException e) {
                t.f.completeExceptionally(e);
            }
        }
    }

    private static void checkTransactionTimeouts() {
        Iterator it = pendingTransactions.iterator();
        while (it.hasNext()) {
            Transaction t = (Transaction)it.next();
            if (t.endTime - System.nanoTime() >= 0L) continue;
            t.silentCloseChannel();
            t.f.completeExceptionally(new SocketTimeoutException("Query timed out"));
            it.remove();
        }
    }

    static CompletableFuture<byte[]> sendrecv(InetSocketAddress local, InetSocketAddress remote, byte[] data, int max, Duration timeout) {
        CompletableFuture<byte[]> f = new CompletableFuture<byte[]>();
        try {
            Selector selector = NioUdpClient.selector();
            DatagramChannel channel = DatagramChannel.open();
            channel.configureBlocking(false);
            if (local == null || local.getPort() == 0) {
                boolean bound = false;
                for (int i = 0; i < 1024; ++i) {
                    try {
                        InetSocketAddress addr = null;
                        if (local == null) {
                            if (prng != null) {
                                addr = new InetSocketAddress(prng.nextInt(EPHEMERAL_RANGE) + EPHEMERAL_START);
                            }
                        } else {
                            int port = local.getPort();
                            if (port == 0 && prng != null) {
                                port = prng.nextInt(EPHEMERAL_RANGE) + EPHEMERAL_START;
                            }
                            addr = new InetSocketAddress(local.getAddress(), port);
                        }
                        channel.bind(addr);
                        bound = true;
                        break;
                    }
                    catch (SocketException addr) {
                        continue;
                    }
                }
                if (!bound) {
                    channel.close();
                    f.completeExceptionally(new IOException("No available source port found"));
                    return f;
                }
            }
            channel.connect(remote);
            long endTime = System.nanoTime() + timeout.toNanos();
            Transaction t = new Transaction(data, max, endTime, channel, f);
            pendingTransactions.add(t);
            registrationQueue.add(t);
            selector.wakeup();
        }
        catch (IOException e) {
            f.completeExceptionally(e);
        }
        return f;
    }

    private static void closeUdp() {
        registrationQueue.clear();
        EOFException closing = new EOFException("Client is closing");
        pendingTransactions.forEach(t -> ((Transaction)t).f.completeExceptionally(closing));
        pendingTransactions.clear();
    }

    private NioUdpClient() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        registrationQueue = new ConcurrentLinkedQueue<Transaction>();
        pendingTransactions = new ConcurrentLinkedQueue<Transaction>();
        int ephemeralStartDefault = 49152;
        int ephemeralEndDefault = 65535;
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            ephemeralStartDefault = 32768;
            ephemeralEndDefault = 60999;
        }
        EPHEMERAL_START = Integer.getInteger("dnsjava.udp.ephemeral.start", ephemeralStartDefault);
        int ephemeralEnd = Integer.getInteger("dnsjava.udp.ephemeral.end", ephemeralEndDefault);
        EPHEMERAL_RANGE = ephemeralEnd - EPHEMERAL_START;
        prng = Boolean.getBoolean("dnsjava.udp.ephemeral.use_ephemeral_port") ? null : new SecureRandom();
        NioUdpClient.addSelectorTimeoutTask(NioUdpClient::processPendingRegistrations);
        NioUdpClient.addSelectorTimeoutTask(NioUdpClient::checkTransactionTimeouts);
        NioUdpClient.addCloseTask(NioUdpClient::closeUdp);
    }

    private static class Transaction
    implements Client.KeyProcessor {
        private final byte[] data;
        private final int max;
        private final long endTime;
        private final DatagramChannel channel;
        private final CompletableFuture<byte[]> f;

        void send() throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(this.data);
            Client.verboseLog("UDP write", this.channel.socket().getLocalSocketAddress(), this.channel.socket().getRemoteSocketAddress(), this.data);
            int n = this.channel.send(buffer, this.channel.socket().getRemoteSocketAddress());
            if (n <= 0) {
                throw new EOFException();
            }
        }

        @Override
        public void processReadyKey(SelectionKey key) {
            int read;
            if (!key.isReadable()) {
                this.silentCloseChannel();
                this.f.completeExceptionally(new EOFException("channel not readable"));
                pendingTransactions.remove(this);
                return;
            }
            DatagramChannel channel = (DatagramChannel)key.channel();
            ByteBuffer buffer = ByteBuffer.allocate(this.max);
            try {
                read = channel.read(buffer);
                if (read <= 0) {
                    throw new EOFException();
                }
            }
            catch (IOException e) {
                this.silentCloseChannel();
                this.f.completeExceptionally(e);
                pendingTransactions.remove(this);
                return;
            }
            buffer.flip();
            byte[] data = new byte[read];
            System.arraycopy(buffer.array(), 0, data, 0, read);
            Client.verboseLog("UDP read", channel.socket().getLocalSocketAddress(), channel.socket().getRemoteSocketAddress(), data);
            this.silentCloseChannel();
            this.f.complete(data);
            pendingTransactions.remove(this);
        }

        private void silentCloseChannel() {
            try {
                this.channel.disconnect();
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Transaction(byte[] data, int max, long endTime, DatagramChannel channel, CompletableFuture<byte[]> f) {
            this.data = data;
            this.max = max;
            this.endTime = endTime;
            this.channel = channel;
            this.f = f;
        }
    }
}

