/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.openjpa;

import java.util.Date;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAEncryptedMailboxMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAMailboxMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMailboxMessage;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.MessageFactory;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;

public class OpenJPAMessageFactory
implements MessageFactory<AbstractJPAMailboxMessage> {
    private final AdvancedFeature feature;

    public OpenJPAMessageFactory(AdvancedFeature feature) {
        this.feature = feature;
    }

    public AbstractJPAMailboxMessage createMessage(MessageId messageId, Mailbox mailbox, Date internalDate, int size, int bodyStartOctet, Content content, Flags flags, PropertyBuilder propertyBuilder, List<MessageAttachmentMetadata> attachments) throws MailboxException {
        switch (this.feature) {
            case Streaming: {
                return new JPAStreamingMailboxMessage(JPAMailbox.from(mailbox), internalDate, size, flags, content, bodyStartOctet, propertyBuilder);
            }
            case Encryption: {
                return new JPAEncryptedMailboxMessage(JPAMailbox.from(mailbox), internalDate, size, flags, content, bodyStartOctet, propertyBuilder);
            }
        }
        return new JPAMailboxMessage(JPAMailbox.from(mailbox), internalDate, size, flags, content, bodyStartOctet, propertyBuilder);
    }

    public static enum AdvancedFeature {
        None,
        Streaming,
        Encryption;

    }
}

