/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.adapter.mailbox.ReIndexerManagementMBean;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.util.MDCBuilder;

public class ReIndexerManagement
implements ReIndexerManagementMBean {
    private final TaskManager taskManager;
    private final ReIndexer reIndexer;

    @Inject
    public ReIndexerManagement(TaskManager taskManager, @Named(value="reindexer") ReIndexer reIndexer) {
        this.taskManager = taskManager;
        this.reIndexer = reIndexer;
    }

    @Override
    public void reIndex(String namespace, String user, String name) throws MailboxException {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"reIndex").build();){
            TaskId taskId = this.taskManager.submit(this.reIndexer.reIndex(new MailboxPath(namespace, Username.of((String)user), name), ReIndexer.RunningOptions.DEFAULT));
            this.taskManager.await(taskId, Duration.of(365L, ChronoUnit.DAYS));
        }
        catch (IOException | TaskManager.ReachedTimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reIndex() throws MailboxException {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"reIndex").build();){
            TaskId taskId = this.taskManager.submit(this.reIndexer.reIndex(ReIndexer.RunningOptions.DEFAULT));
            this.taskManager.await(taskId, Duration.of(365L, ChronoUnit.DAYS));
        }
        catch (IOException | TaskManager.ReachedTimeoutException e) {
            throw new RuntimeException(e);
        }
    }
}

