/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.delivery;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.server.core.MimeMessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxAppender {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxAppender.class);
    private final MailboxManager mailboxManager;

    public MailboxAppender(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public ComposedMessageId append(MimeMessage mail, Username user, String folder) throws MessagingException {
        MailboxSession session = this.createMailboxSession(user);
        return this.append(mail, user, this.useSlashAsSeparator(folder, session), session).getId();
    }

    private String useSlashAsSeparator(String urlPath, MailboxSession session) throws MessagingException {
        String destination = urlPath.replace('/', session.getPathDelimiter());
        if (Strings.isNullOrEmpty((String)destination)) {
            throw new MessagingException("Mail can not be delivered to empty folder");
        }
        if (destination.charAt(0) == session.getPathDelimiter()) {
            destination = destination.substring(1);
        }
        return destination;
    }

    private MessageManager.AppendResult append(MimeMessage mail, Username user, String folder, MailboxSession session) throws MessagingException {
        this.mailboxManager.startProcessingRequest(session);
        try {
            MailboxPath mailboxPath = MailboxPath.forUser((Username)user, (String)folder);
            MessageManager.AppendResult appendResult = this.appendMessageToMailbox(mail, session, mailboxPath);
            return appendResult;
        }
        catch (MailboxException e) {
            throw new MessagingException("Unable to access mailbox.", (Exception)((Object)e));
        }
        finally {
            this.closeProcessing(session);
        }
    }

    private MessageManager.AppendResult appendMessageToMailbox(final MimeMessage mail, MailboxSession session, MailboxPath path) throws MailboxException, MessagingException {
        MessageManager mailbox = this.createMailboxIfNotExist(session, path);
        if (mailbox == null) {
            throw new MessagingException("Mailbox " + path + " for user " + session.getUser().asString() + " was not found on this server.");
        }
        Content content = new Content(){

            public InputStream getInputStream() throws IOException {
                try {
                    return new MimeMessageInputStream(mail);
                }
                catch (MessagingException e) {
                    throw new IOException(e);
                }
            }

            public long size() throws MailboxException {
                try {
                    return MimeMessageUtil.getMessageSize((MimeMessage)mail);
                }
                catch (MessagingException e) {
                    throw new MailboxException("Cannot compute message size", (Throwable)e);
                }
            }
        };
        return mailbox.appendMessage(MessageManager.AppendCommand.builder().recent().build(content), session);
    }

    private MessageManager createMailboxIfNotExist(MailboxSession session, MailboxPath path) throws MailboxException {
        try {
            return this.mailboxManager.getMailbox(path, session);
        }
        catch (MailboxNotFoundException e) {
            try {
                this.mailboxManager.createMailbox(path, session);
                return this.mailboxManager.getMailbox(path, session);
            }
            catch (MailboxExistsException exist) {
                LOGGER.info("Mailbox {} have been created concurrently", (Object)path);
                return this.mailboxManager.getMailbox(path, session);
            }
        }
    }

    public MailboxSession createMailboxSession(Username user) {
        return this.mailboxManager.createSystemSession(user);
    }

    private void closeProcessing(MailboxSession session) throws MessagingException {
        session.close();
        try {
            this.mailboxManager.logout(session);
        }
        finally {
            this.mailboxManager.endProcessingRequest(session);
        }
    }
}

