/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieveserver.netty;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import org.apache.james.managesieve.api.Session;
import org.apache.james.util.MDCBuilder;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelLocal;

public class ManageSieveMDCContext {
    public static Closeable from(ChannelHandlerContext ctx, ChannelLocal<Session> attributes) {
        return MDCBuilder.create().addContext(ManageSieveMDCContext.from((Session)attributes.get(ctx.getChannel()))).addContext("protocol", (Object)"MANAGE-SIEVE").addContext("ip", (Object)ManageSieveMDCContext.retrieveIp(ctx)).addContext("host", (Object)ManageSieveMDCContext.retrieveHost(ctx)).addContext("sessionId", (Object)ctx.getChannel().getId()).build();
    }

    private static String retrieveIp(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getAddress().getHostAddress();
        }
        return remoteAddress.toString();
    }

    private static String retrieveHost(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getHostName();
        }
        return remoteAddress.toString();
    }

    private static MDCBuilder from(Session session) {
        return Optional.ofNullable(session).map(s -> MDCBuilder.create().addContext("user", (Object)s.getUser())).orElse(MDCBuilder.create());
    }
}

