/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.RenameRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.TooLongMailboxNameException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class RenameProcessor
extends AbstractMailboxProcessor<RenameRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenameProcessor.class);

    public RenameProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(RenameRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void processRequest(RenameRequest request, ImapSession session, ImapProcessor.Responder responder) {
        PathConverter pathConverter = PathConverter.forSession(session);
        MailboxPath existingPath = pathConverter.buildFullPath(request.getExistingName());
        MailboxPath newPath = pathConverter.buildFullPath(request.getNewName());
        try {
            MailboxManager mailboxManager = this.getMailboxManager();
            MailboxSession mailboxsession = session.getMailboxSession();
            mailboxManager.renameMailbox(existingPath, newPath, mailboxsession);
            if (existingPath.getName().equalsIgnoreCase("INBOX") && !((Boolean)Mono.from((Publisher)mailboxManager.mailboxExists(existingPath, mailboxsession)).block()).booleanValue()) {
                mailboxManager.createMailbox(existingPath, mailboxsession);
            }
            this.okComplete(request, responder);
            this.unsolicitedResponses(session, responder, false);
        }
        catch (MailboxExistsException e) {
            LOGGER.debug("Rename from {} to {} failed because the target mailbox exists", new Object[]{existingPath, newPath, e});
            this.no(request, responder, HumanReadableText.FAILURE_MAILBOX_EXISTS);
        }
        catch (MailboxNotFoundException e) {
            LOGGER.debug("Rename from {} to {} failed because the source mailbox doesn't exist", new Object[]{existingPath, newPath, e});
            this.no(request, responder, HumanReadableText.MAILBOX_NOT_FOUND);
        }
        catch (TooLongMailboxNameException e) {
            LOGGER.debug("The mailbox name length is over limit: {}", (Object)newPath.getName(), (Object)e);
            this.taggedBad(request, responder, HumanReadableText.FAILURE_MAILBOX_NAME);
        }
        catch (MailboxException e) {
            LOGGER.error("Rename from {} to {} failed", new Object[]{existingPath, newPath, e});
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    @Override
    protected Closeable addContextToMDC(RenameRequest request) {
        return MDCBuilder.create().addContext("action", (Object)"RENAME").addContext("existingName", (Object)request.getExistingName()).addContext("newName", (Object)request.getNewName()).build();
    }
}

