/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import java.util.Date;
import javax.mail.Flags;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.AppendRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendProcessor
extends AbstractMailboxProcessor<AppendRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppendProcessor.class);

    public AppendProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory statusResponseFactory, MetricFactory metricFactory) {
        super(AppendRequest.class, next, mailboxManager, statusResponseFactory, metricFactory);
    }

    @Override
    protected void processRequest(AppendRequest request, ImapSession session, ImapProcessor.Responder responder) {
        String mailboxName = request.getMailboxName();
        Content messageIn = request.getMessage().asMailboxContent();
        Date datetime = request.getDatetime();
        Flags flags = request.getFlags();
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
        session.stopDetectingCommandInjection();
        try {
            MailboxManager mailboxManager = this.getMailboxManager();
            MessageManager mailbox = mailboxManager.getMailbox(mailboxPath, session.getMailboxSession());
            this.appendToMailbox(messageIn, datetime, flags, session, request, mailbox, responder, mailboxPath);
        }
        catch (MailboxNotFoundException e) {
            LOGGER.debug("Append failed for mailbox {}", (Object)mailboxPath, (Object)e);
            this.tryCreate(request, responder, e);
        }
        catch (MailboxException e) {
            LOGGER.error("Append failed for mailbox {}", (Object)mailboxPath, (Object)e);
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    private void tryCreate(AppendRequest request, ImapProcessor.Responder responder, MailboxNotFoundException e) {
        LOGGER.debug("Cannot open mailbox: ", (Throwable)e);
        this.no(request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate());
    }

    private void appendToMailbox(Content message, Date datetime, Flags flagsToBeSet, ImapSession session, AppendRequest request, MessageManager mailbox, ImapProcessor.Responder responder, MailboxPath mailboxPath) {
        try {
            MailboxSession mailboxSession = session.getMailboxSession();
            SelectedMailbox selectedMailbox = session.getSelected();
            boolean isSelectedMailbox = selectedMailbox != null && selectedMailbox.getMailboxId().equals(mailbox.getId());
            ComposedMessageId messageId = mailbox.appendMessage(MessageManager.AppendCommand.builder().withInternalDate(datetime).withFlags(flagsToBeSet).isRecent(!isSelectedMailbox).build(message), mailboxSession).getId();
            if (isSelectedMailbox) {
                selectedMailbox.addRecent(messageId.getUid());
            }
            UidValidity uidValidity = mailbox.getMailboxEntity().getUidValidity();
            this.unsolicitedResponses(session, responder, false);
            this.okComplete(request, StatusResponse.ResponseCode.appendUid(uidValidity, new UidRange[]{new UidRange(messageId.getUid())}), responder);
        }
        catch (MailboxNotFoundException e) {
            this.tryCreate(request, responder, e);
        }
        catch (MailboxException e) {
            LOGGER.error("Unable to append message to mailbox {}", (Object)mailboxPath, (Object)e);
            this.no(request, responder, HumanReadableText.SAVE_FAILED);
        }
    }

    @Override
    protected Closeable addContextToMDC(AppendRequest request) {
        return MDCBuilder.create().addContext("action", (Object)"APPEND").addContext("mailbox", (Object)request.getMailboxName()).build();
    }
}

