/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.events.RegistrationKey;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.quota.QuotaUpdater;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ListeningCurrentQuotaUpdater
implements EventListener.ReactiveGroupEventListener,
QuotaUpdater {
    public static final Group GROUP = new ListeningCurrentQuotaUpdaterGroup();
    private static final ImmutableSet<RegistrationKey> NO_REGISTRATION_KEYS = ImmutableSet.of();
    private final CurrentQuotaManager currentQuotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final EventBus eventBus;
    private final QuotaManager quotaManager;

    @Inject
    public ListeningCurrentQuotaUpdater(CurrentQuotaManager currentQuotaManager, QuotaRootResolver quotaRootResolver, EventBus eventBus, QuotaManager quotaManager) {
        this.currentQuotaManager = currentQuotaManager;
        this.quotaRootResolver = quotaRootResolver;
        this.eventBus = eventBus;
        this.quotaManager = quotaManager;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.Added || event instanceof MailboxEvents.Expunged || event instanceof MailboxEvents.MailboxDeletion;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        if (event instanceof MailboxEvents.Added) {
            MailboxEvents.Added addedEvent = (MailboxEvents.Added)event;
            return Mono.from((Publisher)this.quotaRootResolver.getQuotaRootReactive(addedEvent.getMailboxId())).flatMap(quotaRoot -> this.handleAddedEvent(addedEvent, (QuotaRoot)quotaRoot));
        }
        if (event instanceof MailboxEvents.Expunged) {
            MailboxEvents.Expunged expungedEvent = (MailboxEvents.Expunged)event;
            return Mono.from((Publisher)this.quotaRootResolver.getQuotaRootReactive(expungedEvent.getMailboxId())).flatMap(quotaRoot -> this.handleExpungedEvent(expungedEvent, (QuotaRoot)quotaRoot));
        }
        if (event instanceof MailboxEvents.MailboxDeletion) {
            MailboxEvents.MailboxDeletion mailboxDeletionEvent = (MailboxEvents.MailboxDeletion)event;
            return this.handleMailboxDeletionEvent(mailboxDeletionEvent);
        }
        return Mono.empty();
    }

    private Mono<Void> handleExpungedEvent(MailboxEvents.Expunged expunged, QuotaRoot quotaRoot) {
        return this.computeQuotaOperation((MailboxEvents.MetaDataHoldingEvent)expunged, quotaRoot).flatMap(quotaOperation -> Mono.from((Publisher)this.currentQuotaManager.decrease(quotaOperation)).then(this.dispatchNewQuota(quotaRoot, expunged.getUsername())));
    }

    private Mono<Void> handleAddedEvent(MailboxEvents.Added added, QuotaRoot quotaRoot) {
        return this.computeQuotaOperation((MailboxEvents.MetaDataHoldingEvent)added, quotaRoot).flatMap(quotaOperation -> Mono.from((Publisher)this.currentQuotaManager.increase(quotaOperation)).then(this.dispatchNewQuota(quotaRoot, added.getUsername())));
    }

    private Mono<Void> dispatchNewQuota(QuotaRoot quotaRoot, Username username) {
        Mono quotasMono = Mono.fromCallable(() -> this.quotaManager.getQuotas(quotaRoot));
        return quotasMono.subscribeOn(Schedulers.elastic()).flatMap(quotas -> this.eventBus.dispatch((Event)EventFactory.quotaUpdated().randomEventId().user(username).quotaRoot(quotaRoot).quotaCount((Quota<QuotaCountLimit, QuotaCountUsage>)quotas.getMessageQuota()).quotaSize((Quota<QuotaSizeLimit, QuotaSizeUsage>)quotas.getStorageQuota()).instant(Instant.now()).build(), NO_REGISTRATION_KEYS));
    }

    private Mono<QuotaOperation> computeQuotaOperation(MailboxEvents.MetaDataHoldingEvent metaDataHoldingEvent, QuotaRoot quotaRoot) {
        long size = this.totalSize(metaDataHoldingEvent);
        long count = Integer.toUnsignedLong(metaDataHoldingEvent.getUids().size());
        if (count != 0L && size != 0L) {
            return Mono.just((Object)new QuotaOperation(quotaRoot, QuotaCountUsage.count((long)count), QuotaSizeUsage.size((long)size)));
        }
        return Mono.empty();
    }

    private long totalSize(MailboxEvents.MetaDataHoldingEvent metaDataHoldingEvent) {
        return metaDataHoldingEvent.getUids().stream().mapToLong(uid -> metaDataHoldingEvent.getMetaData(uid).getSize()).sum();
    }

    private Mono<Void> handleMailboxDeletionEvent(MailboxEvents.MailboxDeletion mailboxDeletionEvent) {
        boolean mailboxContainedMessages;
        boolean bl = mailboxContainedMessages = mailboxDeletionEvent.getDeletedMessageCount().asLong() > 0L;
        if (mailboxContainedMessages) {
            return Mono.from((Publisher)this.currentQuotaManager.decrease(new QuotaOperation(mailboxDeletionEvent.getQuotaRoot(), mailboxDeletionEvent.getDeletedMessageCount(), mailboxDeletionEvent.getTotalDeletedSize())));
        }
        return Mono.empty();
    }

    public static class ListeningCurrentQuotaUpdaterGroup
    extends Group {
    }
}

