/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.quota.QuotaRootDeserializer;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultUserQuotaRootResolver
implements UserQuotaRootResolver {
    public static final String SEPARATOR = "&";
    private static final DefaultQuotaRootDeserializer QUOTA_ROOT_DESERIALIZER = new DefaultQuotaRootDeserializer();
    private final SessionProvider sessionProvider;
    private final MailboxSessionMapperFactory factory;

    @Inject
    public DefaultUserQuotaRootResolver(SessionProvider sessionProvider, MailboxSessionMapperFactory factory) {
        this.sessionProvider = sessionProvider;
        this.factory = factory;
    }

    public QuotaRoot forUser(Username username) {
        return QuotaRoot.quotaRoot((String)("#private&" + username.asString()), (Optional)username.getDomainPart());
    }

    public QuotaRoot getQuotaRoot(MailboxPath mailboxPath) {
        Preconditions.checkArgument((!mailboxPath.getNamespace().contains(SEPARATOR) ? 1 : 0) != 0, (String)"Namespace should not contain %s", (Object)SEPARATOR);
        return Optional.ofNullable(mailboxPath.getUser()).map(user -> {
            Preconditions.checkArgument((!mailboxPath.getUser().asString().contains(SEPARATOR) ? 1 : 0) != 0, (String)"Username should not contain %s", (Object)SEPARATOR);
            return mailboxPath.getUser();
        }).map(user -> QuotaRoot.quotaRoot((String)(mailboxPath.getNamespace() + SEPARATOR + user.asString()), (Optional)user.getDomainPart())).orElseGet(() -> QuotaRoot.quotaRoot((String)mailboxPath.getNamespace(), Optional.empty()));
    }

    public QuotaRoot getQuotaRoot(Mailbox mailbox) throws MailboxException {
        return this.getQuotaRoot(mailbox.generateAssociatedPath());
    }

    public QuotaRoot getQuotaRoot(MailboxId mailboxId) throws MailboxException {
        return (QuotaRoot)this.getQuotaRootReactive(mailboxId).block();
    }

    public Mono<QuotaRoot> getQuotaRootReactive(MailboxId mailboxId) {
        MailboxSession session = this.sessionProvider.createSystemSession(Username.of((String)"DefaultUserQuotaRootResolver"));
        return this.factory.getMailboxMapper(session).findMailboxById(mailboxId).map(Mailbox::generateAssociatedPath).map(MailboxPath::getUser).map(this::forUser);
    }

    public QuotaRoot fromString(String serializedQuotaRoot) throws MailboxException {
        return QUOTA_ROOT_DESERIALIZER.fromString(serializedQuotaRoot);
    }

    public Flux<Mailbox> retrieveAssociatedMailboxes(QuotaRoot quotaRoot, MailboxSession mailboxSession) {
        try {
            List<String> parts = QUOTA_ROOT_DESERIALIZER.toParts(quotaRoot.getValue());
            String namespace = parts.get(0);
            String user = parts.get(1);
            return this.factory.getMailboxMapper(mailboxSession).findMailboxWithPathLike(MailboxQuery.builder().namespace(namespace).user(Username.of((String)user)).matchesAllMailboxNames().build().asUserBound());
        }
        catch (MailboxException e) {
            return Flux.error((Throwable)e);
        }
    }

    public static class DefaultQuotaRootDeserializer
    implements QuotaRootDeserializer {
        public QuotaRoot fromString(String serializedQuotaRoot) throws MailboxException {
            List<String> parts = this.toParts(serializedQuotaRoot);
            Username username = Username.of((String)parts.get(1));
            return QuotaRoot.quotaRoot((String)serializedQuotaRoot, (Optional)username.getDomainPart());
        }

        private List<String> toParts(String serializedQuotaRoot) throws MailboxException {
            List parts = Splitter.on((String)DefaultUserQuotaRootResolver.SEPARATOR).splitToList((CharSequence)serializedQuotaRoot);
            if (parts.size() != 2) {
                throw new MailboxException(serializedQuotaRoot + " used as QuotaRoot should contain exactly one \"&\"");
            }
            return parts;
        }
    }
}

