/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import com.github.steveash.guavate.Guavate;
import java.util.Collection;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.store.mail.MessageMapper;

public class FetchGroupConverter {
    public static MessageMapper.FetchType getFetchType(FetchGroup group) {
        if (!group.getPartContentDescriptors().isEmpty()) {
            return MessageMapper.FetchType.Full;
        }
        Collection fetchTypes = (Collection)group.profiles().stream().map(FetchGroupConverter::toFetchType).collect(Guavate.toImmutableList());
        return FetchGroupConverter.reduce(fetchTypes);
    }

    public static MessageMapper.FetchType reduce(Collection<MessageMapper.FetchType> fetchTypes) {
        boolean full = fetchTypes.contains((Object)MessageMapper.FetchType.Full);
        boolean headers = fetchTypes.contains((Object)MessageMapper.FetchType.Headers);
        boolean body = fetchTypes.contains((Object)MessageMapper.FetchType.Body);
        if (full) {
            return MessageMapper.FetchType.Full;
        }
        if (headers && body) {
            return MessageMapper.FetchType.Full;
        }
        if (headers) {
            return MessageMapper.FetchType.Headers;
        }
        if (body) {
            return MessageMapper.FetchType.Body;
        }
        return MessageMapper.FetchType.Metadata;
    }

    private static MessageMapper.FetchType toFetchType(FetchGroup.Profile profile) {
        switch (profile) {
            case HEADERS: {
                return MessageMapper.FetchType.Headers;
            }
            case BODY_CONTENT: {
                return MessageMapper.FetchType.Body;
            }
            case FULL_CONTENT: 
            case MIME_CONTENT: 
            case MIME_HEADERS: 
            case MIME_DESCRIPTOR: {
                return MessageMapper.FetchType.Full;
            }
        }
        throw new NotImplementedException("Unsupported FetchGroup Profile" + profile);
    }
}

