/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.TemporaryResolutionException;
import org.apache.james.dnsservice.library.MXHostAddressIterator;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailetcontainer.impl.LocalResources;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.HostAddress;
import org.apache.mailet.LookupException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JamesMailetContext
implements MailetContext,
Configurable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JamesMailetContext.class);
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    protected final DNSService dns;
    private final DomainList domains;
    private final LocalResources localResources;
    private final MailQueueFactory<?> mailQueueFactory;
    private MailQueue rootMailQueue;
    private MailAddress postmaster;

    @Inject
    public JamesMailetContext(DNSService dns, DomainList domains, LocalResources localResources, MailQueueFactory<?> mailQueueFactory) {
        this.dns = dns;
        this.domains = domains;
        this.localResources = localResources;
        this.mailQueueFactory = mailQueueFactory;
    }

    @PreDestroy
    public void dispose() {
        try {
            this.rootMailQueue.close();
        }
        catch (IOException e) {
            LOGGER.debug("error closing queue", (Throwable)e);
        }
    }

    public Collection<String> getMailServers(Domain host) {
        try {
            return this.dns.findMXRecords(host.asString());
        }
        catch (TemporaryResolutionException e) {
            return ImmutableSet.of();
        }
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object object) {
        this.attributes.put(key, object);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public void bounce(Mail mail, String message) throws MessagingException {
        this.bounce(mail, message, this.getPostmaster());
    }

    public void bounce(Mail mail, String message, MailAddress bouncer) throws MessagingException {
        if (!mail.hasSender()) {
            LOGGER.info("Mail to be bounced contains a null (<>) reverse path.  No bounce will be sent.");
            return;
        }
        LOGGER.info("Processing a bounce request for a message with a reverse path of {}", (Object)mail.getMaybeSender());
        MailImpl reply = this.rawBounce(mail, message);
        if (bouncer != null) {
            reply.getMessage().setFrom((Address)bouncer.toInternetAddress());
        }
        reply.getMessage().saveChanges();
        reply.setSender(null);
        this.sendMail((Mail)reply);
        LifecycleUtil.dispose((Object)reply);
    }

    public List<String> dnsLookup(String s, MailetContext.RecordType recordType) throws LookupException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    private MailImpl rawBounce(Mail mail, String bounceText) throws MessagingException {
        Preconditions.checkArgument((boolean)mail.hasSender(), (Object)"Mail should have a sender");
        MimeMessage original = mail.getMessage();
        MimeMessage reply = (MimeMessage)original.reply(false);
        reply.setSubject("Re: " + original.getSubject());
        reply.setSentDate(new Date());
        ImmutableList recipients = mail.getMaybeSender().asList();
        MailAddress sender = mail.getMaybeSender().get();
        reply.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mail.getMaybeSender().asString()));
        reply.setFrom((Address)new InternetAddress(((MailAddress)mail.getRecipients().iterator().next()).toString()));
        reply.setText(bounceText);
        reply.setHeader("Message-ID", "replyTo-" + mail.getName());
        return MailImpl.builder().name("replyTo-" + mail.getName()).sender(sender).addRecipients((Collection)recipients).mimeMessage(reply).build();
    }

    public boolean isLocalUser(String name) {
        return this.localResources.isLocalUser(name);
    }

    public boolean isLocalEmail(MailAddress mailAddress) {
        return this.localResources.isLocalEmail(mailAddress);
    }

    public Collection<MailAddress> localRecipients(Collection<MailAddress> recipients) {
        return this.localResources.localEmails(recipients);
    }

    public MailAddress getPostmaster() {
        return this.postmaster;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    @Deprecated
    public Iterator<HostAddress> getSMTPHostAddresses(Domain domainName) {
        try {
            return new MXHostAddressIterator(this.dns.findMXRecords(domainName.asString()).iterator(), this.dns, false);
        }
        catch (TemporaryResolutionException e) {
            return ImmutableSet.of().iterator();
        }
    }

    public String getServerInfo() {
        return "Apache JAMES";
    }

    public boolean isLocalServer(Domain domain) {
        return this.localResources.isLocalServer(domain);
    }

    @Deprecated
    public void log(String arg0) {
        LOGGER.info(arg0);
    }

    @Deprecated
    public void log(String arg0, Throwable arg1) {
        LOGGER.info(arg0, arg1);
    }

    @Deprecated
    public void log(MailetContext.LogLevel logLevel, String s) {
        switch (logLevel) {
            case INFO: {
                LOGGER.info(s);
                break;
            }
            case WARN: {
                LOGGER.warn(s);
                break;
            }
            case ERROR: {
                LOGGER.error(s);
                break;
            }
            default: {
                LOGGER.debug(s);
            }
        }
    }

    @Deprecated
    public void log(MailetContext.LogLevel logLevel, String s, Throwable throwable) {
        switch (logLevel) {
            case INFO: {
                LOGGER.info(s, throwable);
                break;
            }
            case WARN: {
                LOGGER.warn(s, throwable);
                break;
            }
            case ERROR: {
                LOGGER.error(s, throwable);
                break;
            }
            default: {
                LOGGER.debug(s, throwable);
            }
        }
    }

    public void sendMail(MimeMessage message) throws MessagingException {
        MailAddress sender = new MailAddress((InternetAddress)message.getFrom()[0]);
        HashSet<MailAddress> recipients = new HashSet<MailAddress>();
        Address[] addresses = message.getAllRecipients();
        if (addresses != null) {
            for (Address address : addresses) {
                if (!(address instanceof InternetAddress)) continue;
                recipients.add(new MailAddress((InternetAddress)address));
            }
        }
        this.sendMail(sender, recipients, message);
    }

    public void sendMail(MailAddress sender, Collection<MailAddress> recipients, MimeMessage message) throws MessagingException {
        this.sendMail(sender, recipients, message, "root");
    }

    public void sendMail(Mail mail) throws MessagingException {
        this.sendMail(mail, Optional.ofNullable(mail.getState()).orElse("root"));
    }

    public void sendMail(Mail mail, long delay, TimeUnit unit) throws MessagingException {
        this.sendMail(mail, "root", delay, unit);
    }

    public void sendMail(Mail mail, String state) throws MessagingException {
        mail.setAttribute(Mail.SENT_BY_MAILET_ATTRIBUTE);
        mail.setState(state);
        this.rootMailQueue.enQueue(mail);
    }

    public void sendMail(Mail mail, String state, long delay, TimeUnit unit) throws MessagingException {
        mail.setAttribute(Mail.SENT_BY_MAILET_ATTRIBUTE);
        mail.setState(state);
        this.rootMailQueue.enQueue(mail, delay, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMail(MailAddress sender, Collection<MailAddress> recipients, MimeMessage message, String state) throws MessagingException {
        MailImpl mail = MailImpl.builder().name(MailImpl.getId()).sender(sender).addRecipients(recipients).mimeMessage(message).build();
        try {
            this.sendMail((Mail)mail, state);
        }
        finally {
            LifecycleUtil.dispose((Object)mail);
        }
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
        this.rootMailQueue = this.mailQueueFactory.createQueue(MailQueueFactory.SPOOL);
        try {
            Object postMasterAddress = config.getString("postmaster", "postmaster").toLowerCase(Locale.US);
            if (((String)postMasterAddress).indexOf(64) < 0) {
                Domain domainName = this.domains.getDomains().stream().filter(Predicate.not(Predicate.isEqual(Domain.LOCALHOST))).findFirst().orElse(this.domains.getDefaultDomain());
                postMasterAddress = (String)postMasterAddress + "@" + domainName.asString();
            }
            try {
                this.postmaster = new MailAddress((String)postMasterAddress);
                if (!this.domains.containsDomain(this.postmaster.getDomain())) {
                    LOGGER.warn("The specified postmaster address ( {} ) is not a local address.  This is not necessarily a problem, but it does mean that emails addressed to the postmaster will be routed to another server.  For some configurations this may cause problems.", (Object)this.postmaster);
                }
            }
            catch (AddressException e) {
                throw new ConfigurationException("Postmaster address " + (String)postMasterAddress + "is invalid", (Throwable)e);
            }
        }
        catch (DomainListException e) {
            throw new ConfigurationException("Unable to access DomainList", (Throwable)e);
        }
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

