/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveash.guavate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import org.apache.commons.lang3.tuple.Pair;

public final class ObjIntPair<A>
implements Comparable<ObjIntPair<A>>,
Serializable {
    private final A first;
    private final int second;
    private static final long serialVersionUID = 1L;

    public static <A> ObjIntPair<A> of(A first, int second) {
        return new ObjIntPair<A>(first, second);
    }

    public static <A> ObjIntPair<A> ofPair(Pair<A, Integer> pair) {
        Preconditions.checkNotNull(pair, (Object)"pair");
        return new ObjIntPair<Object>(pair.getLeft(), (Integer)pair.getRight());
    }

    public ImmutableList<Object> elements() {
        return ImmutableList.of(this.first, (Object)this.second);
    }

    public Pair<A, Integer> toPair() {
        return Pair.of(this.first, (Object)this.second);
    }

    @Override
    public int compareTo(ObjIntPair<A> other) {
        return ComparisonChain.start().compare((Comparable)this.first, (Comparable)other.first).compare(this.second, other.second).result();
    }

    public String toString() {
        return "" + '[' + this.first + ", " + this.second + ']';
    }

    private ObjIntPair(A first, int second) {
        this.first = first;
        this.second = second;
    }

    public A getFirst() {
        return this.first;
    }

    public int getSecond() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjIntPair that = (ObjIntPair)o;
        if (this.second != that.second) {
            return false;
        }
        return this.first != null ? this.first.equals(that.first) : that.first == null;
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + this.second;
        return result;
    }
}

