/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.quota;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.store.quota.CurrentQuotaCalculator;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class InMemoryCurrentQuotaManager
implements CurrentQuotaManager {
    private final LoadingCache<QuotaRoot, AtomicReference<CurrentQuotas>> quotaCache;

    @Inject
    public InMemoryCurrentQuotaManager(final CurrentQuotaCalculator quotaCalculator, final SessionProvider sessionProvider) {
        this.quotaCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<QuotaRoot, AtomicReference<CurrentQuotas>>(){

            public AtomicReference<CurrentQuotas> load(QuotaRoot quotaRoot) {
                return new AtomicReference<CurrentQuotas>(InMemoryCurrentQuotaManager.this.loadQuotas(quotaRoot, quotaCalculator, sessionProvider));
            }
        });
    }

    public CurrentQuotas loadQuotas(QuotaRoot quotaRoot, CurrentQuotaCalculator quotaCalculator, SessionProvider sessionProvider) {
        return (CurrentQuotas)quotaCalculator.recalculateCurrentQuotas(quotaRoot, sessionProvider.createSystemSession(Username.of((String)quotaRoot.getValue()))).subscribeOn(Schedulers.elastic()).block();
    }

    public Mono<Void> increase(QuotaOperation quotaOperation) {
        return this.updateQuota(quotaOperation.quotaRoot(), quota -> quota.increase(new CurrentQuotas(quotaOperation.count(), quotaOperation.size())));
    }

    public Mono<Void> decrease(QuotaOperation quotaOperation) {
        return this.updateQuota(quotaOperation.quotaRoot(), quota -> quota.decrease(new CurrentQuotas(quotaOperation.count(), quotaOperation.size())));
    }

    public Mono<QuotaCountUsage> getCurrentMessageCount(QuotaRoot quotaRoot) {
        return Mono.fromCallable(() -> ((CurrentQuotas)((AtomicReference)this.quotaCache.get((Object)quotaRoot)).get()).count()).onErrorMap(this::wrapAsMailboxException).subscribeOn(Schedulers.elastic());
    }

    public Mono<QuotaSizeUsage> getCurrentStorage(QuotaRoot quotaRoot) {
        return Mono.fromCallable(() -> ((CurrentQuotas)((AtomicReference)this.quotaCache.get((Object)quotaRoot)).get()).size()).onErrorMap(this::wrapAsMailboxException).subscribeOn(Schedulers.elastic());
    }

    public Mono<CurrentQuotas> getCurrentQuotas(QuotaRoot quotaRoot) {
        return Mono.fromCallable(() -> (CurrentQuotas)((AtomicReference)this.quotaCache.get((Object)quotaRoot)).get()).onErrorMap(this::wrapAsMailboxException).subscribeOn(Schedulers.elastic());
    }

    public Mono<Void> setCurrentQuotas(QuotaOperation quotaOperation) {
        return this.getCurrentQuotas(quotaOperation.quotaRoot()).filter(Predicate.not(Predicate.isEqual(CurrentQuotas.from((QuotaOperation)quotaOperation)))).flatMap(storedQuotas -> this.decrease(new QuotaOperation(quotaOperation.quotaRoot(), storedQuotas.count(), storedQuotas.size())).then(this.increase(quotaOperation))).subscribeOn(Schedulers.elastic());
    }

    private Mono<Void> updateQuota(QuotaRoot quotaRoot, UnaryOperator<CurrentQuotas> quotaFunction) {
        return Mono.fromCallable(() -> (CurrentQuotas)((AtomicReference)this.quotaCache.get((Object)quotaRoot)).updateAndGet(quotaFunction)).onErrorMap(this::wrapAsMailboxException).then();
    }

    private Throwable wrapAsMailboxException(Throwable throwable) {
        return new MailboxException("Exception caught", throwable);
    }
}

