/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.task.Hostname;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.task.TaskWithId;
import org.apache.james.task.WorkQueue;
import org.apache.james.task.eventsourcing.CancelCommandHandler;
import org.apache.james.task.eventsourcing.CancelRequested;
import org.apache.james.task.eventsourcing.CompleteCommandHandler;
import org.apache.james.task.eventsourcing.CreateCommandHandler;
import org.apache.james.task.eventsourcing.Created;
import org.apache.james.task.eventsourcing.FailCommandHandler;
import org.apache.james.task.eventsourcing.RequestCancelCommandHandler;
import org.apache.james.task.eventsourcing.StartCommandHandler;
import org.apache.james.task.eventsourcing.TaskAggregateId;
import org.apache.james.task.eventsourcing.TaskCommand;
import org.apache.james.task.eventsourcing.TaskEvent;
import org.apache.james.task.eventsourcing.TaskExecutionDetailsProjection;
import org.apache.james.task.eventsourcing.TerminationSubscriber;
import org.apache.james.task.eventsourcing.UpdateCommandHandler;
import org.apache.james.task.eventsourcing.WorkQueueSupplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tua\u0001B\u000e\u001d\u0001\u001dB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u000f\u0002\u0011)\u0019!C\u0001\u0011\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\n\u0003\u0005R\u0001\t\u0015\r\u0011\"\u0001S\u0011!1\u0006A!A!\u0002\u0013\u0019\u0006\u0002C,\u0001\u0005\u000b\u0007I\u0011\u0001-\t\u0011q\u0003!\u0011!Q\u0001\neC\u0001\"\u0018\u0001\u0003\u0006\u0004%\tA\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005?\"11\r\u0001C\u00019\u0011Dq!a\u0001\u0001\t\u0013\t)\u0001C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012!A\u0011\u0011\t\u0001!\u0002\u0013\t\u0019\u0002C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F!A\u0011Q\n\u0001!\u0002\u0013\t9\u0005C\u0005\u0002P\u0001\u0011\r\u0011\"\u0003\u0002R!A\u0011\u0011\f\u0001!\u0002\u0013\t\u0019\u0006C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h!9\u0011q\u000f\u0001\u0005B\u0005e\u0004bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u0003\u000b\u0003A\u0011IAK\u0011\u001d\tI\u000b\u0001C\u0005\u0003WCq!a1\u0001\t\u0003\n)\rC\u0004\u0002J\u0002!\t%a3\t\u000f\t5\u0001\u0001\"\u0011\u0002^\tARI^3oiN{WO]2j]\u001e$\u0016m]6NC:\fw-\u001a:\u000b\u0005uq\u0012!D3wK:$8o\\;sG&twM\u0003\u0002 A\u0005!A/Y:l\u0015\t\t#%A\u0003kC6,7O\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001A\n\u0006\u0001!\u0002DG\u000f\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nA\u0001\\1oO*\tQ&\u0001\u0003kCZ\f\u0017BA\u0018+\u0005\u0019y%M[3diB\u0011\u0011GM\u0007\u0002=%\u00111G\b\u0002\f)\u0006\u001c8.T1oC\u001e,'\u000f\u0005\u00026q5\taG\u0003\u00028Y\u0005\u0011\u0011n\\\u0005\u0003sY\u0012\u0011b\u00117pg\u0016\f'\r\\3\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014aA1qS*\u0011q\bI\u0001\nY&4WmY=dY\u0016L!!\u0011\u001f\u0003\u0013M#\u0018M\u001d;bE2,\u0017!E<pe.\fV/Z;f'V\u0004\b\u000f\\5feB\u0011A)R\u0007\u00029%\u0011a\t\b\u0002\u0012/>\u00148.U;fk\u0016\u001cV\u000f\u001d9mS\u0016\u0014\u0018AC3wK:$8\u000b^8sKV\t\u0011\n\u0005\u0002K\u001d6\t1J\u0003\u0002M\u001b\u0006QQM^3oiN$xN]3\u000b\u0005u\u0001\u0013BA(L\u0005))e/\u001a8u'R|'/Z\u0001\fKZ,g\u000e^*u_J,\u0007%\u0001\u000efq\u0016\u001cW\u000f^5p]\u0012+G/Y5mgB\u0013xN[3di&|g.F\u0001T!\t!E+\u0003\u0002V9\tqB+Y:l\u000bb,7-\u001e;j_:$U\r^1jYN\u0004&o\u001c6fGRLwN\\\u0001\u001cKb,7-\u001e;j_:$U\r^1jYN\u0004&o\u001c6fGRLwN\u001c\u0011\u0002\u0011!|7\u000f\u001e8b[\u0016,\u0012!\u0017\t\u0003ciK!a\u0017\u0010\u0003\u0011!{7\u000f\u001e8b[\u0016\f\u0011\u0002[8ti:\fW.\u001a\u0011\u0002+Q,'/\\5oCRLwN\\*vEN\u001c'/\u001b2feV\tq\f\u0005\u0002EA&\u0011\u0011\r\b\u0002\u0016)\u0016\u0014X.\u001b8bi&|gnU;cg\u000e\u0014\u0018NY3s\u0003Y!XM]7j]\u0006$\u0018n\u001c8Tk\n\u001c8M]5cKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004fM\u001eD\u0017N\u001b\t\u0003\t\u0002AQA\u0011\u0006A\u0002\rCQa\u0012\u0006A\u0002%CQ!\u0015\u0006A\u0002MCQa\u0016\u0006A\u0002eCQ!\u0018\u0006A\u0002}C#A\u00037\u0011\u000554X\"\u00018\u000b\u0005=\u0004\u0018aC1o]>$\u0018\r^5p]NT!!\u001d:\u0002\r\r|W.\\8o\u0015\t\u0019H/\u0001\u0004h_><G.\u001a\u0006\u0002k\u0006\u00191m\\7\n\u0005]t'!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\"\u0012!\"\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\fa!\u001b8kK\u000e$(\"\u0001@\u0002\u000b)\fg/\u0019=\n\u0007\u0005\u00051P\u0001\u0004J]*,7\r^\u0001\u000fo>\u00148\u000eR5ta\u0006$8\r[3s+\t\t9\u0001\u0005\u0003\u0002\n\u0005-Q\"A'\n\u0007\u00055QJ\u0001\u0006Tk\n\u001c8M]5cKJ\f1\u0002\\8bI\"K7\u000f^8ssV\u0011\u00111\u0003\t\t\u0003+\tY\"a\b\u0002&5\u0011\u0011q\u0003\u0006\u0003\u00033\tQa]2bY\u0006LA!!\b\u0002\u0018\tIa)\u001e8di&|g.\r\t\u0005\u0003\u0013\t\t#C\u0002\u0002$5\u00131\"Q4he\u0016<\u0017\r^3JIB1\u0011qEA\u001c\u0003wi!!!\u000b\u000b\t\u0005-\u0012QF\u0001\naV\u0014G.[:iKJTA!!\u0007\u00020)!\u0011\u0011GA\u001a\u0003\u0011\u0019wN]3\u000b\u0005\u0005U\u0012a\u0002:fC\u000e$xN]\u0005\u0005\u0003s\tICA\u0003T\u001b>tw\u000eE\u0002K\u0003{I1!a\u0010L\u0005\u001dA\u0015n\u001d;pef\fA\u0002\\8bI\"K7\u000f^8ss\u0002\n1#\u001a<f]R\u001cv.\u001e:dS:<7+_:uK6,\"!a\u0012\u0011\t\u0005%\u0011\u0011J\u0005\u0004\u0003\u0017j%aE#wK:$8k\\;sG&twmU=ti\u0016l\u0017\u0001F3wK:$8k\\;sG&twmU=ti\u0016l\u0007%A\u0005x_J\\\u0017+^3vKV\u0011\u00111\u000b\t\u0004c\u0005U\u0013bAA,=\tIqk\u001c:l#V,W/Z\u0001\u000bo>\u00148.U;fk\u0016\u0004\u0013!B:uCJ$HCAA0!\u0011\t)\"!\u0019\n\t\u0005\r\u0014q\u0003\u0002\u0005+:LG/\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0005\u0003S\ny\u0007E\u00022\u0003WJ1!!\u001c\u001f\u0005\u0019!\u0016m]6JI\"1qd\u0005a\u0001\u0003c\u00022!MA:\u0013\r\t)H\b\u0002\u0005)\u0006\u001c8.A\nhKR,\u00050Z2vi&|g\u000eR3uC&d7\u000f\u0006\u0003\u0002|\u0005\u0005\u0005cA\u0019\u0002~%\u0019\u0011q\u0010\u0010\u0003)Q\u000b7o[#yK\u000e,H/[8o\t\u0016$\u0018-\u001b7t\u0011\u001d\t\u0019\t\u0006a\u0001\u0003S\n!!\u001b3\u0002\t1L7\u000f\u001e\u000b\u0003\u0003\u0013\u0003b!a#\u0002\u0012\u0006mTBAAG\u0015\r\ty\tL\u0001\u0005kRLG.\u0003\u0003\u0002\u0014\u00065%\u0001\u0002'jgR$B!!#\u0002\u0018\"9\u0011\u0011\u0014\fA\u0002\u0005m\u0015AB:uCR,8\u000f\u0005\u0003\u0002\u001e\u0006\rfbA\u0019\u0002 &\u0019\u0011\u0011\u0015\u0010\u0002\u0017Q\u000b7o['b]\u0006<WM]\u0005\u0005\u0003K\u000b9K\u0001\u0004Ti\u0006$Xo\u001d\u0006\u0004\u0003Cs\u0012!\u00037jgR\u001c6-\u00197b+\t\ti\u000b\u0005\u0004\u00020\u0006}\u00161\u0010\b\u0005\u0003c\u000bYL\u0004\u0003\u00024\u0006eVBAA[\u0015\r\t9LJ\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005e\u0011\u0002BA_\u0003/\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0014\u0006\u0005'\u0002BA_\u0003/\taaY1oG\u0016dG\u0003BA0\u0003\u000fDq!a!\u0019\u0001\u0004\tI'A\u0003bo\u0006LG\u000f\u0006\u0004\u0002|\u00055\u0017q\u001a\u0005\b\u0003\u0007K\u0002\u0019AA5\u0011\u001d\t\t.\u0007a\u0001\u0003'\fq\u0001^5nK>,H\u000f\u0005\u0003\u0002V\u0006mWBAAl\u0015\r\tI\u000eL\u0001\u0005i&lW-\u0003\u0003\u0002^\u0006]'\u0001\u0003#ve\u0006$\u0018n\u001c8)\u000be\t\t/a@\u0011\r\u0005U\u00111]At\u0013\u0011\t)/a\u0006\u0003\rQD'o\\<t!\u0011\tI/a?\u000f\t\u0005-\u0018q\u0014\b\u0005\u0003[\fIP\u0004\u0003\u0002p\u0006]h\u0002BAy\u0003ktA!a-\u0002t&\tQ%\u0003\u0002$I%\u0011\u0011EI\u0005\u0003?\u0001JA!!@\u0002(\n9\"+Z1dQ\u0016$G+[7f_V$X\t_2faRLwN\\\u0012\u0003\u0003ODS!\u0007B\u0002\u0005\u0017\u0001b!!\u0006\u0002d\n\u0015\u0001cA\u0019\u0003\b%\u0019!\u0011\u0002\u0010\u0003+Q\u000b7o\u001b(pi\u001a{WO\u001c3Fq\u000e,\u0007\u000f^5p]\u000e\u0012!QA\u0001\u0006G2|7/\u001a\u0015\u00045\tE\u0001\u0003\u0002B\n\u00053i!A!\u0006\u000b\u0007\t]Q0\u0001\u0006b]:|G/\u0019;j_:LAAa\u0007\u0003\u0016\tQ\u0001K]3EKN$(o\\=")
public class EventSourcingTaskManager
implements TaskManager,
Closeable,
Startable {
    private final EventStore eventStore;
    private final TaskExecutionDetailsProjection executionDetailsProjection;
    private final Hostname hostname;
    private final TerminationSubscriber terminationSubscriber;
    private final Function1<AggregateId, SMono<History>> loadHistory;
    private final EventSourcingSystem eventSourcingSystem;
    private final WorkQueue workQueue;

    public EventStore eventStore() {
        return this.eventStore;
    }

    public TaskExecutionDetailsProjection executionDetailsProjection() {
        return this.executionDetailsProjection;
    }

    public Hostname hostname() {
        return this.hostname;
    }

    public TerminationSubscriber terminationSubscriber() {
        return this.terminationSubscriber;
    }

    private Subscriber workDispatcher() {
        return x0$1 -> {
            Event event = x0$1;
            if (event instanceof Created) {
                Created created = (Created)event;
                TaskAggregateId aggregateId = created.aggregateId();
                Task task = created.task();
                TaskWithId taskWithId = new TaskWithId(aggregateId.taskId(), task);
                this.workQueue().submit(taskWithId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (event instanceof CancelRequested) {
                CancelRequested cancelRequested = (CancelRequested)event;
                TaskAggregateId aggregateId = cancelRequested.aggregateId();
                this.workQueue().cancel(aggregateId.taskId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        };
    }

    private Function1<AggregateId, SMono<History>> loadHistory() {
        return this.loadHistory;
    }

    private EventSourcingSystem eventSourcingSystem() {
        return this.eventSourcingSystem;
    }

    private WorkQueue workQueue() {
        return this.workQueue;
    }

    public void start() {
        this.workQueue().start();
    }

    /*
     * WARNING - void declaration
     */
    public TaskId submit(Task task) {
        void var2_2;
        TaskId taskId = TaskId.generateTaskId();
        TaskCommand.Create command = new TaskCommand.Create(taskId, task);
        SMono qual$1 = SMono$.MODULE$.apply(this.eventSourcingSystem().dispatch((Command)command));
        Duration x$1 = qual$1.block$default$1();
        qual$1.block(x$1);
        return var2_2;
    }

    public TaskExecutionDetails getExecutionDetails(TaskId id) {
        return (TaskExecutionDetails)this.executionDetailsProjection().load(id).getOrElse((Function0 & Serializable)() -> {
            throw new TaskNotFoundException();
        });
    }

    public java.util.List<TaskExecutionDetails> list() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.listScala()).asJava();
    }

    public java.util.List<TaskExecutionDetails> list(TaskManager.Status status) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.listScala().filter((Function1 & Serializable)details -> BoxesRunTime.boxToBoolean((boolean)EventSourcingTaskManager.$anonfun$list$1(status, details)))).asJava();
    }

    private List<TaskExecutionDetails> listScala() {
        return this.executionDetailsProjection().list();
    }

    public void cancel(TaskId id) {
        TaskCommand.RequestCancel command = new TaskCommand.RequestCancel(id);
        SMono qual$1 = SMono$.MODULE$.apply(this.eventSourcingSystem().dispatch((Command)command));
        Duration x$1 = qual$1.block$default$1();
        qual$1.block(x$1);
    }

    public TaskExecutionDetails await(TaskId id, java.time.Duration timeout) throws TaskNotFoundException, TaskManager.ReachedTimeoutException {
        TaskExecutionDetails taskExecutionDetails;
        try {
            Mono details = Mono.fromSupplier(() -> this.getExecutionDetails(id)).filter(x$1 -> x$1.getStatus().isFinished());
            Mono findEvent = Flux.from(this.terminationSubscriber().listenEvents()).filter(x0$1 -> {
                boolean bl;
                Event event = x0$1;
                if (event instanceof TaskEvent) {
                    TaskEvent taskEvent = (TaskEvent)event;
                    TaskId taskId = taskEvent.getAggregateId().taskId();
                    TaskId taskId2 = id;
                    bl = !(taskId != null ? !taskId.equals(taskId2) : taskId2 != null);
                } else {
                    bl = false;
                }
                return bl;
            }).next().then(details);
            taskExecutionDetails = (TaskExecutionDetails)Flux.merge((Publisher[])new Publisher[]{findEvent, details}).subscribeOn(Schedulers.elastic()).blockFirst(timeout);
        }
        catch (IllegalStateException illegalStateException) {
            throw new TaskManager.ReachedTimeoutException();
        }
        return taskExecutionDetails;
    }

    @Override
    @PreDestroy
    public void close() {
        this.workQueue().close();
    }

    public static final /* synthetic */ boolean $anonfun$list$1(TaskManager.Status status$1, TaskExecutionDetails details) {
        TaskManager.Status status = details.getStatus();
        TaskManager.Status status2 = status$1;
        return !(status != null ? !status.equals(status2) : status2 != null);
    }

    @Inject
    @VisibleForTesting
    public EventSourcingTaskManager(WorkQueueSupplier workQueueSupplier, EventStore eventStore, TaskExecutionDetailsProjection executionDetailsProjection, Hostname hostname, TerminationSubscriber terminationSubscriber) {
        this.eventStore = eventStore;
        this.executionDetailsProjection = executionDetailsProjection;
        this.hostname = hostname;
        this.terminationSubscriber = terminationSubscriber;
        this.loadHistory = (Function1 & Serializable)aggregateId -> SMono$.MODULE$.apply(this.eventStore().getEventsOfAggregate(aggregateId));
        this.eventSourcingSystem = new EventSourcingSystem((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CommandHandler[]{new CreateCommandHandler(this.loadHistory(), hostname), new StartCommandHandler(this.loadHistory(), hostname), new RequestCancelCommandHandler(this.loadHistory(), hostname), new CompleteCommandHandler(this.loadHistory()), new CancelCommandHandler(this.loadHistory()), new FailCommandHandler(this.loadHistory()), new UpdateCommandHandler(this.loadHistory())})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Subscriber[]{executionDetailsProjection.asSubscriber(hostname), this.workDispatcher(), terminationSubscriber})), eventStore);
        this.workQueue = workQueueSupplier.apply(this.eventSourcingSystem());
    }
}

