/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.CapaCapability;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.protocols.pop3.core.MessageMetaDataUtils;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UidlCmdHandler
implements CommandHandler<POP3Session>,
CapaCapability {
    private static final Logger LOGGER = LoggerFactory.getLogger(UidlCmdHandler.class);
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"UIDL");
    private static final Set<String> CAPS = ImmutableSet.of((Object)"UIDL");
    private final MetricFactory metricFactory;

    @Inject
    public UidlCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-uidl", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addContext("action", (Object)"UIDL").addContext(MDCConstants.withSession(session)).addContext(MDCConstants.forRequest(request)), () -> this.uidl(session, request)));
    }

    private Response uidl(POP3Session session, Request request) {
        LOGGER.trace("UIDL command received");
        POP3Response response = null;
        String parameters = request.getArgument();
        if (session.getHandlerState() == 2) {
            List uidList = (List)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
            List deletedUidList = (List)session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
            try {
                String identifier = session.getUserMailbox().getIdentifier();
                if (parameters == null) {
                    response = new POP3Response("+OK", "unique-id listing follows");
                    for (int i = 0; i < uidList.size(); ++i) {
                        MessageMetaData metadata = (MessageMetaData)uidList.get(i);
                        if (deletedUidList.contains(metadata.getUid())) continue;
                        StringBuilder responseBuffer = new StringBuilder().append(i + 1).append(" ").append(metadata.getUid(identifier));
                        response.appendLine(responseBuffer.toString());
                    }
                    response.appendLine(".");
                }
                int num = 0;
                try {
                    num = Integer.parseInt(parameters);
                    MessageMetaData metadata = MessageMetaDataUtils.getMetaData(session, num);
                    if (metadata == null) {
                        StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                        return new POP3Response("-ERR", responseBuffer.toString());
                    }
                    if (!deletedUidList.contains(metadata.getUid())) {
                        StringBuilder responseBuffer = new StringBuilder(64).append(num).append(" ").append(metadata.getUid(identifier));
                        response = new POP3Response("+OK", responseBuffer.toString());
                    }
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
                catch (IndexOutOfBoundsException npe) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
                catch (NumberFormatException nfe) {
                    StringBuilder responseBuffer = new StringBuilder(64).append(parameters).append(" is not a valid number");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
            }
            catch (IOException e) {
                return POP3Response.ERR;
            }
        } else {
            return POP3Response.ERR;
        }
        return response;
    }

    @Override
    public Set<String> getImplementedCapabilities(POP3Session session) {
        if (session.getHandlerState() == 2) {
            return CAPS;
        }
        return Collections.emptySet();
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

