/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es.v7;

import com.google.common.annotations.VisibleForTesting;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.apache.james.backends.es.v7.RoutingKey;
import org.apache.james.backends.es.v7.WriteAliasName;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import reactor.core.publisher.Mono;

public class DeleteByQueryPerformer {
    private final ReactorElasticSearchClient client;
    private final WriteAliasName aliasName;

    @VisibleForTesting
    DeleteByQueryPerformer(ReactorElasticSearchClient client, WriteAliasName aliasName) {
        this.client = client;
        this.aliasName = aliasName;
    }

    public Mono<Void> perform(QueryBuilder queryBuilder, RoutingKey routingKey) {
        DeleteByQueryRequest deleteRequest = new DeleteByQueryRequest(new String[]{this.aliasName.getValue()});
        deleteRequest.setQuery(queryBuilder);
        deleteRequest.setRouting(routingKey.asString());
        return this.client.deleteByQuery(deleteRequest, RequestOptions.DEFAULT).then();
    }
}

